// 节点类型 1开始节点，2结束节点、 3审批节点，4条件节点(就是线)，5排他网关，6并行网关
/**
 * 节点默认属性
 */
export default {
  // 开始节点
  1: {
    nodeName: '开始节点',
    size: {
      width: 40,
      height: 40
    },
    allow: ['3', '4', '5', '6', '7'], // 允许生成 审批节点、排他网关、并行网关、条件节点
    nodeType: '1',
    content: ''
  },
  // 结束节点
  2: {
    nodeName: '结束节点',
    size: {
      width: 40,
      height: 40
    },
    allow: [],
    nodeType: '2',
    content: ''
  },
  // 审批节点
  3: {
    nodeName: '审批节点',
    size: {
      width: 220,
      height: 80
    },
    allow: ['2', '3', '4', '5', '6', '7'], // 允许生成 审批节点、排他网关、并行网关、条件节点，结束节点
    nodeType: '3',
    content: '审批节点内容'
  },
  // 条件节点
  4: {
    nodeName: '条件节点',
    size: {
      width: 220,
      height: 80
    },
    allow: ['2', '3'], // 允许生成 审批节点、结束节点
    nodeType: '4',
    content: '条件内容'
  },
  // 排他网关
  5: {
    nodeName: '排他网关',
    size: {
      width: 40,
      height: 40
    },
    allow: ['4'], // 允许生成 条件节点
    nodeType: '5',
    content: '排他网关内容'
  },
  // 并行网关
  6: {
    nodeName: '并行节点',
    size: {
      width: 40,
      height: 40
    },
    allow: ['3'], // 允许生成 审批节点
    nodeType: '6',
    content: '并行网关内容'
  },
  // 抄送节点
  7: {
    nodeName: '抄送节点',
    size: {
      width: 220,
      height: 80
    },
    allow: ['2', '3'], // 允许生成 审批节点、结束节点
    nodeType: '7',
    content: '抄送节点内容'
  }
}