export interface INodes {
  'id': string
  'processId'?: number
  'nodeCode': string
  'nodeType': string
  'nodeName': string
  'inputNodeCode': string[]
  'outputNodeCode': string[]
  'userTypeParams'?: any
  'userTypeSelectIds'?: any
  'conditionParams'?: any
  'callbackFlag'?: string
  'isSubProcess'?: string
  'isParallel'?: string
  'approveTimeLimitType'?: string
  'approveTimeLimit'?: null
  'applicationId'?: null
  'applicationTodoUrl'?: null
  'nodePath': {
    position: {
      x: number
      y: number
    }
    from: string[]
    to: string[]
    size: {
      width: number
      height: number
    }
    paths: Array<{
      id: ''
      from: {
        originX: number
        originY: number
        id: number
      }
      to: {
        originX: number
        originY: number
        id: number
      }
      type: number
      points: number[][]
    }>
  }
  'authConfig'?: any
  'nodeButtonConfig'?: any[]
  'nodeMonitorConfig'?: any[]
  'nodeSubprocessesConfig'?: any[]
}

export interface BaseNode {
  id: string
  pid?: string
  nodeType: string
  nodeName: string
  nodeColor: string
  lowerLevelNum?: number | null | string
  fold?: boolean
  [key: string]: any
}
export interface Nodes extends BaseNode {
  children?: Nodes[]
}