// 节点类型 1开始节点，2结束节点、 3审批节点，4条件节点(就是线)，5排他网关，6并行网关
interface Node {
  nodeName: string
  size: {
    width: number
    height: number
  }
  nodeType: string
  content?: string
}
/**
 * 节点默认属性
 */
export default {
  // 集团
  0: {
    nodeName: '集团',
    size: {
      width: 348,
      height: 205
    },
    nodeType: '1',
    content: ''
  },
  // 公司
  1: {
    nodeName: '公司',
    size: {
      width: 348,
      height: 205
    },
    nodeType: '1',
    content: ''
  },
  // 部门
  2: {
    nodeName: '部门',
    size: {
      width: 348,
      height: 205
    },
    allow: [],
    nodeType: '2',
    content: ''
  },
  // 审批节点内容
  3: {
    nodeName: '课',
    size: {
      width: 348,
      height: 205
    },
    nodeType: '3',
    content: ''
  },
  // 组
  4: {
    nodeName: '组',
    size: {
      width: 348,
      height: 205
    },
    nodeType: '4',
    content: '条件内容'
  },
  // 助理
  5: {
    nodeName: '助理',
    size: {
      width: 240,
      height: 100
    },
    nodeType: '5',
    content: '助理'
  }
}

export const gutter = {
  x: 60,
  y: 40
}