import nodesDefault, { gutter } from './nodesDefault'
import { varibles } from '../Vector/Hooks/SvgWrap'

const {
  svgWrap
} = varibles

/**
 * 递归求左边界
 * @param node 节点数据
 * @param {Array<number>} array x集合
 * @param depth 节点层级
 */
function f1(node, array, depth) {
  if (Array.isArray(node.children) && node.children.length && !node.fold) {
    let { x } = node.children[0].position
    if (typeof array[depth + 1] === 'undefined') {
      array[depth + 1] = x
    } else {
      if (x < array[depth + 1]) {
        array[depth + 1] = x
      }
    }
    for (let i = 0; i < node.children.length; i++) {
      f1(node.children[i], array, depth + 1)
    }
  }
}

/**
 * 递归求右边界
 * @param node 节点数据
 * @param {Array<number>} array x集合
 * @param depth 节点层级
 */
function f2(node, array, depth) {
  if (Array.isArray(node.children) && node.children.length && !node.fold) {
    let { x } = node.children[node.children.length - 1].position
    if (!array[depth + 1]) {
      array[depth + 1] = x
    } else {
      if (x > array[depth + 1]) {
        array[depth + 1] = x
      }
    }
    for (let i = 0; i < node.children.length; i++) {
      f2(node.children[i], array, depth + 1)
    }
  }
}

/**
 * 求左边界，返回新的数组。
 * @param node 节点数据
 * @returns {Array<number>} 左边界
 */
function f3(node) {
  const left = [node.position.x]
  f1(node, left, 0)
  return left
}

/**
 * 求右边界，在旧数组上修改。
 * @param node 节点数据
 * @param {Array<number>} right 右边界
 */
function f4(node, right) {
  right[0] = node.position.x
  f2(node, right, 0)
}

/**
 * 通过左右边界计算偏移量
 * @param {Array<number>} right 右边界
 * @param {Array<number>} left 左边界
 * @returns {number} 偏移量
 */
function f5(right, left) {
  let number = left.length < right.length ? left.length : right.length
  let depth = left.length > right.length ? left.length : right.length
  let offset = right[0] - left[0]
  for (let i = 1; i < number; i++) {
    if (right[i] - left[i] > offset) {
      offset = right[i] - left[i]
    }
  }
  return offset + 1 + (depth - 1) * 0.2
}

/**
 * 平移所有节点
 * @param node 节点数据
 * @param offset 偏移量
 */
function f6(node, offset) {
  node.position.x += offset
  if (Array.isArray(node.children) && node.children.length && !node.fold) {
    for (let i = 0; i < node.children.length; i++) {
      f6(node.children[i], offset)
    }
  }
}

/**
 * 计算所有节点横向虚拟位置，稍后根据画布尺寸以及横竖要求计算所有节点真实位置。
 * @param node 节点数据
 */
function f7(node) {
  if (!node.position) node.position = { x: 0, y: 0 }
  if (!node.size) node.size = nodesDefault[node.nodeType].size
  if (Array.isArray(node.children) && node.children.length && !node.fold) {
    let right = [] // 右边界
    for (let i = 0; i < node.children.length; i++) {
      const currentNode = node.children[i]
      const preNode = node.children[i - 1]
      f7(currentNode)
      if (i > 0) {
        f4(preNode, right) // 把前面所有子树当做整体，更新这个整体的右边界。
        let left = f3(currentNode) // 取这个子树的左边界
        let offset = f5(right, left) // 左右边界比较，求这个子树的偏移量
        f6(currentNode, offset) // 整体移动这个子树
      }
    }
    node.position.x = (node.children[0].position.x + node.children[node.children.length - 1].position.x) / 2 // 父节点在第一个子节点和最后一个子节点的中间。
  } else {
    node.position.x = 0
  }
}

// 计算总深度和总宽度
function f8(node) {
  let right = []
  f4(node, right)
  let maxW = right[0]
  for (let i = 1; i < right.length; i++) {
    if (maxW < right[i]) {
      maxW = right[i]
    }
  }
  return [maxW, right.length - 1]
}

// 根据画布位置和尺寸以及横竖布局来确定所有节点的最终位置
function f9(node, depth, offsetX, offsetY, horizontal = false) {
  if (horizontal) {
    node.position.y = Math.round(depth * nodesDefault[node.nodeType].size.height + gutter.y + offsetY)
    node.position.x = Math.round(node.position.x * nodesDefault[node.nodeType].size.width + gutter.x * 2 + offsetX)
  } else {
    node.position.y = Math.round(node.position.x + offsetY)
    node.position.x = Math.round(depth + offsetX)
  }
  if (Array.isArray(node.children) && node.children.length) {
    for (let i = 0; i < node.children.length; i++) {
      f9(node.children[i], depth + 1, offsetX, offsetY, horizontal)
    }
  }
}

// 横向布局
export function horizontal(node, x, y) {
  // console.log('svgWrap', svgWrap.value)
  f7(node)
  // let size = f8(node)
  f9(node, 0, x, y, true)
}

// 竖向布局
export function vertical(node, x, y) {
  f7(node)
  let size = f8(node)
  f9(node, 0, x, y, false)
}