// 递归求左边界
function f1(obj, array, depth) {
  if ((typeof obj.children === 'object') && (obj.children.length > 0)) {
    let x = obj.children[0].x
    if (typeof array[depth + 1] === 'undefined') {
      array[depth + 1] = x
    } else {
      if (x < array[depth + 1]) {
        array[depth + 1] = x
      }
    }
    for (let i = 0; i < obj.children.length; i++) {
      f1(obj.children[i], array, depth + 1)
    }
  }
}

// 递归求右边界
function f2(obj, array, depth) {
  if ((typeof obj.children === 'object') && (obj.children.length > 0)) {
    let x = obj.children[obj.children.length - 1].x
    if (typeof array[depth + 1] === 'undefined') {
      array[depth + 1] = x
    } else {
      if (x > array[depth + 1]) {
        array[depth + 1] = x
      }
    }
    for (let i = 0; i < obj.children.length; i++) {
      f2(obj.children[i], array, depth + 1)
    }
  }
}

// 求左边界，返回新的数组。
function f3(obj) {
  let left: any = []
  left[0] = obj.x
  f1(obj, left, 0)
  return left
}

// 求右边界，在旧数组上修改。
function f4(obj, right) {
  console.log('f4', obj.x)
  right[0] = obj.x
  f2(obj, right, 0)
}

// 通过左右边界计算偏移量
function f5(right, left) {
  let number = left.length < right.length ? left.length : right.length
  let depth = left.length > right.length ? left.length : right.length
  let offset = right[0] - left[0]
  for (let i = 1; i < number; i++) {
    if (right[i] - left[i] > offset) {
      offset = right[i] - left[i]
    }
  }
  return offset + 1 + (depth - 1) * 0.2
}

// 平移所有节点
function f6(obj, offset) {
  obj.x += offset
  if ((typeof obj.children === 'object') && (obj.children.length > 0)) {
    for (let i = 0; i < obj.children.length; i++) {
      f6(obj.children[i], offset)
    }
  }
}

// 计算所有节点横向虚拟位置，稍后根据画布尺寸以及横竖要求计算所有节点真实位置。
function f7(obj) {
  if ((typeof obj.children === 'object') && (obj.children.length > 0)) {
    let right = [] // 右边界
    for (let i = 0; i < obj.children.length; i++) {
      f7(obj.children[i])
      if (i > 0) {
        console.log('f7', obj.children[i - 1].x)
        f4(obj.children[i - 1], right) // 把前面所有子树当做整体，更新这个整体的右边界。
        let left = f3(obj.children[i]) // 取这个子树的左边界
        let offset = f5(right, left) // 左右边界比较，求这个子树的偏移量
        f6(obj.children[i], offset) // 整体移动这个子树
      }
    }
    console.log('', obj.x)
    obj.x = (obj.children[0].x + obj.children[obj.children.length - 1].x) / 2 // 父节点在第一个子节点和最后一个子节点的中间。
  } else {
    // 叶子节点
    obj.x = 0
  }
}

// 计算总深度和总宽度
function f8(obj) {
  let right = []
  f4(obj, right)
  let maxW = right[0]
  for (let i = 1; i < right.length; i++) {
    if (maxW < right[i]) {
      maxW = right[i]
    }
  }
  return [maxW, right.length - 1]
}

// 根据画布位置和尺寸以及横竖布局来确定所有节点的最终位置
function f9(obj, depth, offsetX, offsetY, ratioW, ratioH, horizontal) {
  if (horizontal) {
    obj.y = Math.round(depth * ratioH + offsetY)
    obj.x = Math.round(obj.x * ratioW + offsetX)
  } else {
    obj.y = Math.round(obj.x * ratioH + offsetY)
    obj.x = Math.round(depth * ratioW + offsetX)
  }
  if ((typeof obj.children === 'object') && (obj.children.length > 0)) {
    for (let i = 0; i < obj.children.length; i++) {
      f9(obj.children[i], depth + 1, offsetX, offsetY, ratioW, ratioH, horizontal)
    }
  }
}

// 横向布局
export function horizontal(obj, x, y, w = 1500, h = 800) {
  f7(obj)
  let size = f8(obj)
  f9(obj, 0, x, y, w / size[0], h / size[1], true)
}

// 竖向布局
function vertical(obj, x, y, w = 1500, h = 800) {
  f7(obj)
  let size = f8(obj)
  f9(obj, 0, x, y, w / size[1], h / size[0], false)
}