import { createApp, h } from 'vue'

import Cookies from 'js-cookie'

import { ElConfigProvider, ElTable, ElTableColumn, ElTree, ElForm, ElInput, ElSelect, ElSelectV2, ElTreeSelect, ElDatePicker, ElTimePicker, ElCascader } from 'element-plus'
import ElementPlus from 'element-plus'
// import locale from 'element-plus/dist/locale/zh-cn.mjs' // 中文语言
import 'element-plus/theme-chalk/index.css'
// import 'uno.css'
import './assets/styles/index.scss' // global css

import App from './App.vue'
import store from './store'
import router from './router'
import directive from './directive' // directive

// 注册指令
import plugins from './plugins' // plugins
import { download } from './utils/request'

// svg图标
import 'virtual:svg-icons-register'
import SvgIcon from './components/SvgIcon/index.vue'
import elementIcons from './components/SvgIcon/svgicon'

import './permission' // permission control

import { useDict } from './utils/dict'
import { parseTime, resetForm, addDateRange, handleTree, selectDictLabel, selectDictLabels, calculateAge, addMonthsToDate } from './utils/ruoyi'
import { getIDCardInfo } from './utils/idCard'
import { isEmployee } from './utils/checkIsEmployee'

// checkbox和inputnumber 组件
import CheckboxNumber from './components/CheckboxNumber/index.vue'
// 分页组件
import Pagination from './components/Pagination/index.vue'
// 自定义表格工具组件
import RightToolbar from './components/RightToolbar/index.vue'
// 富文本组件
import Editor from './components/Editor/index.vue'
// 文件上传组件
import FileUpload from './components/FileUpload/index.vue'
// 图片上传组件
import ImageUpload from './components/ImageUpload/index.vue'
// 图片预览组件
import ImagePreview from './components/ImagePreview/index.vue'
// 自定义树选择组件
import TreeSelect from './components/TreeSelect/index.vue'
// 字典标签组件
import DictTag from './components/DictTag/index.vue'
// 图片上传组件
import CustomUpload from './components/CustomUpload/index.vue'
// PageTitle组件
import PageTitle from './components/PageTitle/index.vue'
// 获取table暂无数据
// import EmptyTable from './components/Empty/EmptyTable'
import Anchor from './components/Anchor/index.vue'
// 分割线标题
import DividerTitle from './components/DividerTitle/index.vue'

import CustomForm from './components/CustomForm/index.vue'
// 上传头像
import AvatarUpload from './components/AvatarUpload/index.vue'

// 任职部门
import DeptTreeSelects from './components/Select/DeptTreeSelectsMultiple.vue'

// 公司选择下拉框
import CompanySelect from './components/Select/CompanySelect.vue'

// 任职岗位
import PostSelect from './components/Select/PostSelect.vue'

// 任职岗位
import ButtonMore from './components/Button/ButtonMore.vue'
// 审批历程
import FlowApproval from './localComponents/FlowDesign/InfoDetail/FlowApproval.vue'
// 审批历程
import FlowApprovalInfo from './localComponents/FlowDesign/InfoDetail/FlowApprovalInfo.vue'
// 树默认折叠展开图标
import { TreeIconFold } from './components/Tree/TreeIconFold/TreeIconFold'

// ...纯表格
import VxeTable from 'vxe-table'
import 'vxe-table/lib/style.css'
// ...

// ...可选 UI
import VxeUI from 'vxe-pc-ui'
import 'vxe-pc-ui/lib/style.css'


const app = createApp(App)

// VxeUI.setI18n('zh-CN', zhCN)
VxeUI.setLanguage('zh-CN')

app.use(store)
app.use(router)
app.use(plugins)
app.use(elementIcons)

app.use(VxeUI).use(VxeTable)
// 全局方法挂载
app.config.globalProperties.useDict = useDict
app.config.globalProperties.download = download
app.config.globalProperties.parseTime = parseTime
app.config.globalProperties.resetForm = resetForm
app.config.globalProperties.handleTree = handleTree
app.config.globalProperties.addDateRange = addDateRange
app.config.globalProperties.selectDictLabel = selectDictLabel
app.config.globalProperties.selectDictLabels = selectDictLabels
app.config.globalProperties.calculateAge = calculateAge
app.config.globalProperties.getIDCardInfo = getIDCardInfo
app.config.globalProperties.addMonthsToDate = addMonthsToDate
app.config.globalProperties.isEmployee = isEmployee

// 全局组件挂载
app.component('CheckboxNumber', CheckboxNumber)
app.component('svg-icon', SvgIcon)
app.component('DictTag', DictTag)
app.component('Pagination', Pagination)
app.component('TreeSelect', TreeSelect)
app.component('FileUpload', FileUpload)
app.component('ImageUpload', ImageUpload)
app.component('ImagePreview', ImagePreview)
app.component('RightToolbar', RightToolbar)
app.component('Editor', Editor)
app.component('CustomUpload', CustomUpload)
app.component('PageTitle', PageTitle)
app.component('Anchor', Anchor)
app.component('DividerTitle', DividerTitle)
app.component('CustomForm', CustomForm)
app.component('AvatarUpload', AvatarUpload)
app.component('CompanySelect', CompanySelect)
app.component('DeptTreeSelects', DeptTreeSelects)
app.component('PostSelect', PostSelect)
app.component('ButtonMore', ButtonMore)
app.component('FlowApproval', FlowApproval)
app.component('FlowApprovalInfo', FlowApprovalInfo)

directive(app)


// console.log(ElementPlus)
// console.log(ElTree)
ElTree.props.icon = {
  type: [Object, String, Function],
  default: TreeIconFold
}
ElConfigProvider.props.size
ElInput.props.clearable.default = true
ElDatePicker.props.clearable = {
  type: Boolean,
  default: true
}
ElTimePicker.props.clearable = {
  type: Boolean,
  default: true
}
ElSelectV2.props.clearable.default = {
  type: Boolean,
  default: true
}
ElTreeSelect.props.clearable = {
  type: Boolean,
  default: true
}
ElSelect.props.clearable = {
  type: Boolean,
  default: true
}
ElCascader.props.clearable = {
  type: Boolean,
  default: true
}
// ElCard.props.shadow.default = 'never'
// ElTableColumn.props.align.default = 'center'
ElTable.props.showOverflowTooltip = {
  type: Boolean,
  default: true
}
ElTableColumn.props.align = {
  type: String,
  default: 'left'
}
// 获取组件的props
const ElFormProps = ElForm.props
ElFormProps.labelPosition = {
  type: String,
  default: 'top'
}


// console.log(ElTable)
// const ElTableslot = ElTable.useSlot()


// console.log('ElTableslot', ElTableslot)
// 使用element-plus 并且设置全局的大小
app.use(ElementPlus, {
  // locale: locale,
  // 支持 large、default、small
  size: Cookies.get('size') || 'default'
})

app.mount('#app')
