import { to as tos } from 'await-to-js'
import { ElMessage } from 'element-plus'
import router from './router'
import NProgress from 'nprogress'
import 'nprogress/nprogress.css'
import { getToken } from '@/utils/auth'
import { getQueryObject } from '@/utils'
import { isHttp } from '@/utils/validate'
import { isRelogin } from '@/utils/request'
import useUserStore from '@/store/modules/user'
import useSettingsStore from '@/store/modules/settings'
import usePermissionStore from '@/store/modules/permission'
import noticePolling from '@/layout/components/Fab/polling'
import { refreshDeptTreeList, refreshPostList, refreshAllUserList, refreshCompanyList } from '@/utils/transcoding'
import { open } from '@/common/passwordModify'

NProgress.configure({ showSpinner: false })
const whiteList = ['/login', '/register', '/social-callback']

router.beforeEach(async (to, from, next) => {
  const userStore = useUserStore()
  NProgress.start()
  if (getToken()) {
    // console.log('getToken', getToken())
    to.meta.title && useSettingsStore().setTitle(to.meta.title as string)
    /* has token*/
    if (to.path === '/login') {
      next({ path: '/' })
      NProgress.done()
    } else if (whiteList.indexOf(to.path) !== -1) {
      next()
    } else {
      if (userStore.roles.length === 0) {
        isRelogin.show = true
        // 判断当前用户是否已拉取完user_info信息
        const [err] = await tos(userStore.getInfo())
        if (err) {
          await userStore.logoutFeed()
          ElMessage.error(err)
          next({ path: '/' })
        } else {
          if (userStore.passwordStatus !== '0') {
            await open(userStore.passwordStatus)
          }
          isRelogin.show = false
          const accessRoutes = await usePermissionStore().generateRoutes()
          // 通知轮询
          noticePolling()

          refreshDeptTreeList()
          refreshPostList()
          refreshAllUserList()
          refreshCompanyList()
          // 根据roles权限生成可访问的路由表
          accessRoutes.forEach((route) => {
            if (!isHttp(route.path)) {
              router.addRoute(route) // 动态添加可访问路由表
            }
          })
          // next()
          next({ ...to, replace: true }) // hack方法 确保addRoutes已完成
        }
      } else {
        next()
      }
    }
  } else {
    // 没有token
    if (whiteList.indexOf(to.path) !== -1) {
      // 在免登录白名单，直接进入
      next()
    } else {
      await userStore.updateSso()
      if (userStore.sso) {
        // console.log('sso')
        const urlParams: any = getQueryObject()
        if (urlParams.code) {
          const [err, res] = await tos(userStore.ssoLogin({ code: urlParams.code }))
          if (res) {
            // next({ path: '/' })
            if (urlParams.state) {
              const state = decodeURIComponent(String(urlParams.state || ''))
              const r = router.resolve(state)
              next(r)
            } else {
              next('/')
            }
          } else {
            next(false)
          }
        } else {
          // 跳转地址到单点登录页面
          userStore.authorize(to)
          next(false)
        }
      } else {
        next(`/login?redirect=${to.fullPath}`) // 否则全部重定向到登录页
      }
      NProgress.done()
    }
  }
})

router.afterEach(() => {
  NProgress.done()
})
