import { h } from 'vue'
import router from '@/router'
import { ElMessageBox } from 'element-plus'
import PromptItem from './PromptItem.vue'

function onSelect(item) {
  ElMessageBox.close()
  router.push(item.route)
}

export function openPromptPermission() {
  ElMessageBox({
    title: '警告 - 请先完善账号安全信息',
    showConfirmButton: false,
    showClose: false,
    customClass: '',
    // message: PromptItem
    message: h(
      PromptItem, {
        onSelectPrompt: onSelect
      }
    )
  })
}
