import { computed, reactive, ref, type Ref } from 'vue'
import { defineStore } from 'pinia'
import { useStorage } from '@vueuse/core'
import { selectUserNotReadCount } from '@/api/system/notice'
import zhCN from 'element-plus/es/locale/lang/zh-cn'
import enUS from 'element-plus/es/locale/lang/en'

export const useAppStore = defineStore('app', (): {
  device: Ref<string>
  sidebar: {
    opened: boolean
    withoutAnimation: boolean
    hide: boolean
    showHamburger: boolean
    showSettings: boolean
  }
  language: any
  locale: any
  size: '' | 'small' | 'default' | 'large' | 'maximum-large' | 'extra-large'
  notice: any // 通知消息数量
  scrollTop: Ref<number> // 当前垂直滚动高度
  changeLanguage: (val: string) => void
  toggleSideBar: (withoutAnimation: boolean) => void
  toggleHamburger: (val: boolean) => void
  toggleSettings: (val: boolean) => void
  closeSideBar: ({ withoutAnimation }: any) => void
  toggleDevice: (d: string) => void
  setSize: (s: string) => void
  toggleSideBarHide: (status: boolean) => void
  updateNotice: () => Promise<void>
  updateScrollTop: (top: number) => void
} => {
  const sidebarStatus: any = useStorage('sidebarStatus', '1')
  const sidebar = reactive({
    opened: sidebarStatus.value ? !!+sidebarStatus.value : true,
    withoutAnimation: false,
    hide: false,
    showHamburger: true,
    showSettings: false
  })
  const device = ref<string>('desktop')
  const size: any = useStorage('size', 'default')
  const notice = ref<number>(0)
  const scrollTop = ref<number>(0)

  // 语言
  const language: any = useStorage('language', 'zh_CN')
  const languageObj: any = {
    en_US: enUS,
    zh_CN: zhCN
  }
  const locale = computed(() => {
    return languageObj[language.value]
  })

  const toggleSideBar = (withoutAnimation: boolean) => {
    console.log('toggleSideBar sidebar.opened:', sidebar.opened)
    if (sidebar.hide) {
      return false
    }
    sidebar.opened = !sidebar.opened
    sidebar.withoutAnimation = withoutAnimation
    if (sidebar.opened) {
      sidebarStatus.value = '1'
    } else {
      sidebarStatus.value = '0'
    }
  }

  const closeSideBar = ({ withoutAnimation }: any): void => {
    sidebarStatus.value = '0'
    sidebar.opened = false
    sidebar.withoutAnimation = withoutAnimation
  }
  const toggleDevice = (d: string): void => {
    device.value = d
  }
  const setSize = (s: string): void => {
    document.body.classList.remove(`size--${size.value}`)
    size.value = s
    document.body.classList.add(`size--${size.value}`)
  }
  // 切换显示隐藏侧边栏开关
  const toggleSideBarHide = (status: boolean): void => {
    sidebar.hide = status
  }
  // 切换显示展开收起按钮
  const toggleHamburger = (status: boolean): void => {
    sidebar.showHamburger = status ?? !sidebar.showHamburger
  }
  // 切换显示布局弹窗
  const toggleSettings = (status: boolean): void => {
    sidebar.showSettings = status ?? !sidebar.showSettings
  }

  const changeLanguage = (val: string): void => {
    language.value = val
  }
  // 查询通知
  const updateNotice = (): Promise<void> => {
    return selectUserNotReadCount().then(res => {
      notice.value = res.data
    })
  }
  // 更新滚动垂直高度
  const updateScrollTop = (top): void => {
    scrollTop.value = top
  }

  return {
    device,
    sidebar,
    language,
    locale,
    size,
    notice,
    scrollTop,
    changeLanguage,
    toggleSideBar,
    closeSideBar,
    toggleDevice,
    setSize,
    toggleSideBarHide,
    toggleHamburger,
    toggleSettings,
    updateNotice,
    updateScrollTop
  }
})

export default useAppStore
