import { ref, type Ref } from 'vue'
import { defineStore } from 'pinia'
import defaultSettings from '@/settings'
import { SettingTypeEnum } from '@/enums/SettingTypeEnum'
import { useDynamicTitle } from '@/utils/dynamicTitle'

export const useSettingsStore = defineStore('setting', () => {
  const storageSetting = JSON.parse(localStorage.getItem('layout-setting') || '{}')

  const prop: { [key: string]: Ref<any> } = {
    title: ref<string>(''),
    layout: ref<string>(storageSetting.layout ?? defaultSettings.layout),
    theme: ref<string>(storageSetting.theme || defaultSettings.theme),
    sideTheme: ref<string>(storageSetting.sideTheme || defaultSettings.sideTheme),
    showSettings: ref<boolean>(storageSetting.showSettings || defaultSettings.showSettings),
    showHamburger: ref<boolean>(storageSetting.showHamburger || defaultSettings.showHamburger),
    topNav: ref<boolean>(storageSetting.topNav ?? defaultSettings.topNav),
    tagsView: ref<boolean>(storageSetting.tagsView ?? defaultSettings.tagsView),
    tagsViewStyle: ref<string>(storageSetting.tagsViewStyle ?? defaultSettings.tagsViewStyle),
    fixedHeader: ref<boolean>(storageSetting.fixedHeader ?? defaultSettings.fixedHeader),
    sidebarLogo: ref<boolean>(storageSetting.sidebarLogo ?? defaultSettings.sidebarLogo),
    dynamicTitle: ref<boolean>(storageSetting.dynamicTitle ?? defaultSettings.dynamicTitle),
    animationEnable: ref<boolean>(storageSetting.animationEnable ?? defaultSettings.animationEnable),
    dark: ref<boolean>(storageSetting.dark || defaultSettings.dark)
  }

  const { title, layout, theme, sideTheme, showSettings, showHamburger, topNav, tagsView, tagsViewStyle, fixedHeader, sidebarLogo, dynamicTitle, animationEnable, dark } = prop

  // actions
  const changeSetting = (param: { key: SettingTypeEnum; value: any }) => {
    const { key, value } = param
    if (key in prop) {
      prop[key].value = value
    }
  }
  const setTitle = (value: string) => {
    title.value = value
    useDynamicTitle()
  }
  return {
    title,
    layout,
    theme,
    sideTheme,
    showSettings,
    showHamburger,
    topNav,
    tagsView,
    tagsViewStyle,
    fixedHeader,
    sidebarLogo,
    dynamicTitle,
    animationEnable,
    dark,
    changeSetting,
    setTitle
  }
})

export default useSettingsStore
