import useUserStore from '@/store/modules/user'
import { getEmployeesByCode } from '@/api/personnelManagement/employees'

/**
 * 验证当前登陆人是不是员工
 * @returns
 */
export async function isEmployee() {
  const userStore = useUserStore()
  const userInfo = userStore.userInfo
  // console.log(userInfo, '========userInfo========')
  if (!userInfo.userCode) {
    return false
  }
  try {
    // 用工号获取员工信息
    const res = await getEmployeesByCode(userInfo.userCode)
    return res.data && res.data.employeesCode === userInfo.userCode
  } catch (error) {
    console.error('Error while fetching employee data:', error)
    return false
  }
}