// r,g,b范围为[0,255],转换成h范围为[0,360]
// s,l为百分比形式，范围是[0,100],可根据需求做相应调整
function rgbtohsl(r, g, b) {
  r = r / 255
  g = g / 255
  b = b / 255

  let min = Math.min(r, g, b)
  let max = Math.max(r, g, b)
  let l = (min + max) / 2
  let difference = max - min
  let h = 0
  let s = 0
  if (max === min) {
    h = 0
    s = 0
  } else {
    s = l > 0.5 ? difference / (2.0 - max - min) : difference / (max + min)
    switch (max) {
      case r: h = (g - b) / difference + (g < b ? 6 : 0);break
      case g: h = 2.0 + (b - r) / difference;break
      case b: h = 4.0 + (r - g) / difference;break
    }
    h = Math.round(h * 60)
  }
  s = Math.round(s * 100)// 转换成百分比的形式
  l = Math.round(l * 100)
  return [h, s, l]
}

// r,g,b范围为[0,255],转换成h范围为[0,360]
// s,v为百分比形式，范围是[0,100],可根据需求做相应调整
function rgbtohsv(r, g, b) {
  r = r / 255
  g = g / 255
  b = b / 255
  let h, s, v
  let min = Math.min(r, g, b)
  let max = v = Math.max(r, g, b)
  let l = (min + max) / 2
  let difference = max - min

  if (max === min) {
    h = 0
  } else {
    switch (max) {
      case r: h = (g - b) / difference + (g < b ? 6 : 0);break
      case g: h = 2.0 + (b - r) / difference;break
      case b: h = 4.0 + (r - g) / difference;break
    }
    h = Math.round(h * 60)
  }
  if (max === 0) {
    s = 0
  } else {
    s = 1 - min / max
  }
  s = Math.round(s * 100)
  v = Math.round(v * 100)
  return [h, s, v]
}

// 输入的h范围为[0,360],s,l为百分比形式的数值,范围是[0,100]
// 输出r,g,b范围为[0,255],可根据需求做相应调整
function hsltorgb(h: number, s: number, l: number) {
  h = h / 360
  s = s / 100
  l = l / 100
  let rgb: number[] = []

  if (s === 0) {
    rgb = [Math.round(l * 255), Math.round(l * 255), Math.round(l * 255)]
  } else {
    let q = l >= 0.5 ? (l + s - l * s) : (l * (1 + s))
    let p = 2 * l - q
    let tr = rgb[0] = h + 1 / 3
    let tg = rgb[1] = h
    let tb = rgb[2] = h - 1 / 3
    for (let i = 0; i < rgb.length;i++) {
      let tc = rgb[i]
      console.log(tc)
      if (tc < 0) {
        tc = tc + 1
      } else if (tc > 1) {
        tc = tc - 1
      }
      switch (true) {
        case (tc < (1 / 6)):
          tc = p + (q - p) * 6 * tc
          break
        case ((1 / 6) <= tc && tc < 0.5):
          tc = q
          break
        case (0.5 <= tc && tc < (2 / 3)):
          tc = p + (q - p) * (4 - 6 * tc)
          break
        default:
          tc = p
          break
      }
      rgb[i] = Math.round(tc * 255)
    }
  }

  return rgb
}

// 输入的h范围为[0,360],s,l为百分比形式的数值,范围是[0,100]
// 输出r,g,b范围为[0,255],可根据需求做相应调整
function hsvtorgb(h: number, s: number, v: number): [number, number, number] {
  s = s / 100
  v = v / 100
  let h1 = Math.floor(h / 60) % 6
  let f = h / 60 - h1
  let p = v * (1 - s)
  let q = v * (1 - f * s)
  let t = v * (1 - (1 - f) * s)
  let r = 0
  let g = 0
  let b = 0
  switch (h1) {
    case 0:
      r = v
      g = t
      b = p
      break
    case 1:
      r = q
      g = v
      b = p
      break
    case 2:
      r = p
      g = v
      b = t
      break
    case 3:
      r = p
      g = q
      b = v
      break
    case 4:
      r = t
      g = p
      b = v
      break
    case 5:
      r = v
      g = p
      b = q
      break
  }
  return [Math.round(r * 255), Math.round(g * 255), Math.round(b * 255)]
}

// rgb转16进制
function rgbToColor(rgb: string): string {
  let aColor = rgb.replace(/(?:\(|\)|rgb|RGB)*/g, '').split(',')
  let strHex = '#'
  for (let i = 0; i < aColor.length; i++) {
    let hex = Math.round(Number(aColor[i])).toString(16)
    if (hex.length < 2) {
      hex = '0' + hex
    }
    strHex += hex
  }
  return strHex
}

// 十六进制转rgb值
function colorRgb(string: string): number[] {
  let sColor = string.toLowerCase()
  // let reg = /^#([0-9a-fA-f]{3}|[0-9a-fA-f]{6})$/
  let sColorChange: number[] = []
  // if (sColor && reg.test(sColor)) {
  for (let i = 1; i < 7; i += 2) {
    sColorChange.push(parseInt('0x' + sColor.slice(i, i + 2)))
  }
  // }
  return sColorChange
}

// hsb[hsv]转rgb
function hsbToRgb(h: number, s: number, v: number): string {
  // var h = arr[0], s = arr[1], v = arr[2];
  s = s / 100
  v = v / 100
  let r = 0, g = 0, b = 0
  let i = parseInt(String((h / 60) % 6))
  let f = h / 60 - i
  let p = v * (1 - s)
  let q = v * (1 - f * s)
  let t = v * (1 - (1 - f) * s)
  switch (i) {
    case 0:
      r = v; g = t; b = p
      break
    case 1:
      r = q; g = v; b = p
      break
    case 2:
      r = p; g = v; b = t
      break
    case 3:
      r = p; g = q; b = v
      break
    case 4:
      r = t; g = p; b = v
      break
    case 5:
      r = v; g = p; b = q
      break
    default:
      break
  }
  r = parseInt(String(r * 255.0))
  g = parseInt(String(g * 255.0))
  b = parseInt(String(b * 255.0))
  // return [r, g, b];
  return `rgb(${r},${g},${b})`
}

// 使用示例
// let originalColor = 'hsl(250, 50%, 50%)'
// let newColor = makeColorLighter(originalColor, 10, 10)
// console.log(newColor) // 输出可能类似于 "hsl(250, 40%, 60%)"
export function makeColorLighter(hslColor: string, brightnessDelta: number = 20, saturationDelta: number = 20): string {
  let parts = hslColor.split(/[^\d]/).filter(item => item !== '')
  let h: string | number = parts[0]
  let s: string | number = parts[1]
  let l: string | number = parts[2]

  // 减少亮度和饱和度
  l = parseInt(l, 10) + brightnessDelta
  s = parseInt(s, 10) - saturationDelta

  // 确保亮度和饱和度在正确的范围内
  l = Math.max(0, Math.min(100, l))
  s = Math.max(0, Math.min(100, s))

  // 返回新的HSL颜色字符串
  return `hsl(${h}, ${s}%, ${l}%)`
}

// 方法1：使用Math.random()生成0~255之间的随机整数，并拼接成RGB颜色值
// function getRandomColor() {
//   let r = Math.floor(Math.random() * 256)
//   let g = Math.floor(Math.random() * 256)
//   let b = Math.floor(Math.random() * 256)
//   return 'rgb(' + r + ',' + g + ',' + b + ')'
// }

// 方法2：使用toString(16)将随机数转为16进制，并补齐两位
// function getRandomColor() {
//   let color = '#' + Math.floor(Math.random() * 16777215).toString(16).padStart(6, '0')
//   return color
// }

// 生成hsl随机颜色（较深）
export function getRandomColor() {
  // 设置随机色相（0-360度），饱和度（40%-100%），亮度（10%-40%）
  const hue = Math.floor(Math.random() * 360)
  const saturation = 40 + Math.floor(Math.random() * 30)
  const lightness = 10 + Math.floor(Math.random() * 40)

  // 将HSL值转换为字符串
  const hsl = `hsl(${hue}, ${saturation}%, ${lightness}%)`

  return hsl
}
