import { ref, toRefs, type ToRefs } from 'vue'
import { getDicts } from '@/api/system/dict/data.js'
import { useDictStore } from '@/store/modules/dict'
/**
 * 获取字典数据
 */
export const useDict = (...args: string[]): ToRefs<{ [key: string]: DictDataOption[] }> => {
  const res = ref<{[key: string]: DictDataOption[]}>({})
  return (() => {
    args.forEach(async (dictType) => {
      res.value[dictType] = []
      const dicts = useDictStore().getDict(dictType)
      if (dicts) {
        res.value[dictType] = dicts
      } else {
        await getDicts(dictType).then((resp) => {
          res.value[dictType] = resp.data.map(
            (p): DictDataOption => ({ label: p.dictLabel, value: p.dictValue, elTagType: p.listClass, elTagClass: p.cssClass })
          )
          useDictStore().setDict(dictType, res.value[dictType])
        })
      }
    })
    return toRefs<{ [key: string]: DictDataOption[] }>(res.value)
  })()
}
