export const categoriesDe = ([
  {
    id: 'de1',
    name: '道德品行',
    maxScore: 20,
    subcategories: [
      {
        id: 'de1-1',
        name: '总体评价',
        items: [
          {
            id: 'de1-1-1',
            name: '上年度《集团中层管理人员年度考核测评》——总体评价结果',
            maxScore: 12,
            value: null,
            options: [
              { label: '优秀（12分）', score: 12 },
              { label: '称职（10分）', score: 10 },
              { label: '基本称职（8分）', score: 8 },
              { label: '不称职（-5分）', score: -5 }
            ]
          }
        ]
      },
      {
        id: 'de1-2',
        name: '“德”评价',
        items: [
          {
            id: 'de1-2-1',
            name: '上年度《集团中层管理人员年度考核测评》——“德”评价结果',
            maxScore: 8,
            value: null,
            options: [
              { label: '优秀（8分）', score: 8 },
              { label: '称职（6分）', score: 6 },
              { label: '基本称职（4分）', score: 4 },
              { label: '不称职（-2分）', score: -2 }
            ]
          }
        ]
      }
    ]
  },
  {
    id: 'de2',
    name: '政治思想建设',
    maxScore: 15,
    subcategories: [
      {
        id: 'de2-1',
        name: '班子总体评价',
        items: [
          {
            id: 'de2-1-1',
            name: '上年度《二级企业领导班子年度考核》——总体评价结果',
            maxScore: 12,
            value: null,
            options: [
              { label: '优秀（12分）', score: 12 },
              { label: '良好（10分）', score: 10 },
              { label: '一般（8分）', score: 8 },
              { label: '较差（-5分）', score: -5 }
            ]
          }
        ]
      },
      {
        id: 'de2-2',
        name: '班子政治思想建设评价',
        items: [
          {
            id: 'de2-2-1',
            name: '上年度《二级企业领导班子年度考核》——“政治思想建设”评价结果',
            maxScore: 8,
            value: null,
            options: [
              { label: '优秀（8分）', score: 8 },
              { label: '良好（6分）', score: 6 },
              { label: '一般（4分）', score: 4 },
              { label: '较差（-2分）', score: -2 }
            ]
          }
        ]
      }
    ]
  },
  {
    id: 'de3',
    name: '对党忠诚',
    maxScore: 30,
    subcategories: [
      {
        id: 'de3-1',
        name: '政治忠诚、政治定力、政治担当、政治能力、政治自律',
        items: [
          {
            id: 'de3-1-1',
            name: '上年度《政治表现正向评价》——总体评价结果',
            maxScore: 15,
            value: null,
            options: [
              { label: '好（15分）', score: 15 },
              { label: '较好（13分）', score: 13 },
              { label: '一般（10分）', score: 10 },
              { label: '差（-5分）', score: -5 }
            ]
          }
        ]
      },
      {
        id: 'de3-2',
        name: '遵守党的纪律、履行党员义务、履行岗位职责、发挥先锋模范作用',
        items: [
          {
            id: 'de3-2-1',
            name: '上年度《民主评议党员测评》——综合评价结果',
            maxScore: 15,
            value: null,
            options: [
              { label: '优秀（15分）', score: 15 },
              { label: '合格（13分）', score: 13 },
              { label: '基本合格（10分）', score: 10 },
              { label: '不合格（-5分）', score: -5 }
            ]
          }
        ]
      }
    ]
  },
  {
    id: 'de4',
    name: '党建工作',
    maxScore: 35,
    subcategories: [
      {
        id: 'de4-1',
        name: '党建职责',
        items: [
          {
            id: 'de4-1-1',
            name: '《干部任免审批表》——党内职务',
            maxScore: 20,
            value: null,
            options: [
              { label: '党委/总支书记（20分）', score: 20 },
              { label: '党委/总支副书记（18分）', score: 18 },
              { label: '党委/总支委员（16分）', score: 16 },
              { label: '支部书记（12分）', score: 12 },
              { label: '支部委员（10分）', score: 10 }
            ]
          }
        ]
      },
      {
        id: 'de4-2',
        name: '党管人才',
        items: [
          {
            id: 'de4-2-1',
            name: '《党组织书记履行干部选拔任用工作职责情况民主评议》——书记总体评价结果',
            maxScore: 2,
            value: null,
            options: [
              { label: '好（2分）', score: 2 },
              { label: '一般（1.5分）', score: 1.5 },
              { label: '不好（-1分）', score: -1 }
            ]
          }
        ]
      },
      {
        id: 'de4-3',
        name: '组织建设',
        items: [
          {
            id: 'de4-3-1',
            name: '支部标准化率——对标《党支部建设标准化手册》，达标支部占比',
            maxScore: 1.5,
            value: null,
            options: [
              { label: '达标（1.5分）', score: 1.5 },
              { label: '不达标（0分）', score: 0 }
            ]
          },
          {
            id: 'de4-3-2',
            name: '组织生活规范度——“三会一课”完成率',
            maxScore: 1.5,
            value: null,
            options: [
              { label: '达标（1.5分）', score: 1.5 },
              { label: '不达标（0分）', score: 0 }
            ]
          }
        ]
      },
      {
        id: 'de4-4',
        name: '贯彻中央八项规定精神',
        items: [
          {
            id: 'de4-4-1',
            name: '贯彻中央八项规定精神学习教育实施方案要求完成情况',
            maxScore: 10,
            value: null,
            options: [
              { label: '达标（10分）', score: 10 },
              { label: '不达标（0分）', score: 0 }
            ]
          }
        ]
      }
    ]
  }
])
export const categoriesNeng = ([
  {
    id: 'neng1',
    name: '综合能力',
    maxScore: 20,
    subcategories: [
      {
        id: 'neng1-1',
        name: '总体评价',
        items: [
          {
            id: 'neng1-1-1',
            name: '上年度《集团中层管理人员年度考核测评》——总体评价结果',
            maxScore: 12,
            value: null,
            options: [
              { label: '优秀（12分）', score: 12 },
              { label: '称职（10分）', score: 10 },
              { label: '基本称职（8分）', score: 8 },
              { label: '不称职（-5分）', score: -5 }
            ]
          }
        ]
      },
      {
        id: 'neng1-2',
        name: '“能”评价',
        items: [
          {
            id: 'neng1-2-1',
            name: '上年度《集团中层管理人员年度考核测评》——“能”评价结果',
            maxScore: 8,
            value: null,
            options: [
              { label: '优秀（8分）', score: 8 },
              { label: '称职（6分）', score: 6 },
              { label: '基本称职（4分）', score: 4 },
              { label: '不称职（-2分）', score: -2 }
            ]
          }
        ]
      }
    ]
  },
  {
    id: 'neng2',
    name: '领导能力',
    maxScore: 15,
    subcategories: [
      {
        id: 'neng2-1',
        name: '班子总体评价',
        items: [
          {
            id: 'neng2-1-1',
            name: '上年度《二级企业领导班子年度考核》——总体评价结果',
            maxScore: 10,
            value: null,
            options: [
              { label: '优秀（10分）', score: 10 },
              { label: '良好（8分）', score: 8 },
              { label: '一般（6分）', score: 6 },
              { label: '较差（-5分）', score: -5 }
            ]
          }
        ]
      },
      {
        id: 'neng2-2',
        name: '班子“领导能力”评价',
        items: [
          {
            id: 'neng2-2-1',
            name: '上年度《二级企业领导班子年度考核》——“领导能力”评价结果',
            maxScore: 5,
            value: null,
            options: [
              { label: '优秀（10分）', score: 5 },
              { label: '良好（8分）', score: 4 },
              { label: '一般（6分）', score: 3 },
              { label: '较差（-5分）', score: -2 }
            ]
          }
        ]
      }
    ]
  },
  {
    id: 'neng3',
    name: '团队建设',
    maxScore: 30,
    subcategories: [
      {
        id: 'neng3-1',
        name: '干部选拔任用',
        items: [
          {
            id: 'neng3-1-1',
            name: '上年度《干部选拔任用工作民主评议》——单位总体评价',
            maxScore: 7,
            value: null,
            options: [
              { label: '好（12分）', score: 7 },
              { label: '一般（10分）', score: 5 },
              { label: '不好（8分）', score: -3 }
            ]
          },
          {
            id: 'neng3-1-2',
            name: '上年度《干部选拔任用工作民主评议》——全方位管理和经常性监督评价',
            maxScore: 7,
            value: null,
            options: [
              { label: '好（12分）', score: 7 },
              { label: '一般（10分）', score: 5 },
              { label: '不好（8分）', score: -3 }
            ]
          }
        ]
      },
      {
        id: 'neng3-2',
        name: '创新突破',
        items: [
          {
            id: 'neng3-2-1',
            name: '任职以来企业取得高新技术企业、雏鹰企业、瞪羚企业、专精特新企业、市企业技术中心等科技称号',
            maxScore: 7,
            value: null,
            options: [
              { label: '一项（4分）', score: 4 },
              { label: '两项（8分）', score: 8 },
              { label: '三项（12分）', score: 12 },
              { label: '四项（16分）', score: 16 }
            ]
          }
        ]
      }
    ]
  },
  {
    id: 'neng4',
    name: '职责能力',
    maxScore: 35,
    subcategories: [
      {
        id: 'neng4-1',
        name: '行政职责',
        items: [
          {
            id: 'neng4-1-1',
            name: '《干部任免审批表》——行政职务',
            maxScore: 20,
            value: null,
            options: [
              { label: '集团层面（20分）', score: 20 },
              { label: '正职（18分）', score: 18 },
              { label: '副职（16分）', score: 16 }
            ]
          }
        ]
      },
      {
        id: 'neng4-2',
        name: '学历、学位',
        items: [
          {
            id: 'neng4-2-1',
            name: '学历',
            maxScore: 3.5,
            value: null,
            options: [
              { label: '专科（2分）', score: 2 },
              { label: '本科（3分）', score: 3 },
              { label: '研究生（3.5分）', score: 3.5 }
            ]
          },
          {
            id: 'neng4-2-2',
            name: '学位',
            maxScore: 3.5,
            value: null,
            options: [
              { label: '学士学位（2.5分）', score: 2.5 },
              { label: '硕士学位（3分）', score: 3 },
              { label: '博士学位（3.5分）', score: 3.5 }
            ]
          }
        ]
      },
      {
        id: 'neng4-3',
        name: '专业技术资格',
        items: [
          {
            id: 'neng4-3-1',
            name: '专业技术职务（职称）',
            maxScore: 4,
            value: null,
            options: [
              { label: '初级（2.5分）', score: 2.5 },
              { label: '中级（3分）', score: 3 },
              { label: '高级（3.5分）', score: 3.5 },
              { label: '正高级（4分）', score: 4 }
            ]
          },
          {
            id: 'neng4-3-2',
            name: '执业资格(国家执业资格认定证书)',
            maxScore: 4,
            value: null,
            options: [
              { label: '取得（4分）', score: 4 },
              { label: '未取得（0分）', score: 0 }
            ]
          }
        ]
      }
    ]
  }
])
export const categoriesJi = ([
  {
    id: 'ji1',
    name: '履职尽责',
    maxScore: 20,
    subcategories: [
      {
        id: 'ji1-1',
        name: '总体评价',
        items: [
          {
            id: 'ji1-1-1',
            name: '上年度《集团中层管理人员年度考核测评》——总体评价结果',
            maxScore: 12,
            value: null,
            options: [
              { label: '优秀（12分）', score: 12 },
              { label: '称职（10分）', score: 10 },
              { label: '基本称职（8分）', score: 8 },
              { label: '不称职（-5分）', score: -5 }
            ]
          }
        ]
      },
      {
        id: 'ji1-2',
        name: '“绩”评价',
        items: [
          {
            id: 'ji1-2-1',
            name: '上年度《集团中层管理人员年度考核测评》——“绩”评价结果',
            maxScore: 8,
            value: null,
            options: [
              { label: '优秀（8分）', score: 8 },
              { label: '称职（6分）', score: 6 },
              { label: '基本称职（4分）', score: 4 },
              { label: '不称职（-2分）', score: -2 }
            ]
          }
        ]
      }
    ]
  },
  {
    id: 'ji2',
    name: '工作实绩',
    maxScore: 15,
    subcategories: [
      {
        id: 'ji2-1',
        name: '班子总体评价',
        items: [
          {
            id: 'ji2-1-1',
            name: '上年度《二级企业领导班子年度考核》——总体评价结果',
            maxScore: 10,
            value: null,
            options: [
              { label: '优秀（10分）', score: 10 },
              { label: '良好（8分）', score: 8 },
              { label: '一般（6分）', score: 6 },
              { label: '较差（-5分）', score: -5 }
            ]
          }
        ]
      },
      {
        id: 'ji2-2',
        name: '班子“工作实绩”评价',
        items: [
          {
            id: 'ji2-2-1',
            name: '上年度《二级企业领导班子年度考核》——“工作实绩”评价结果',
            maxScore: 5,
            value: null,
            options: [
              { label: '优秀（5分）', score: 5 },
              { label: '良好（4分）', score: 4 },
              { label: '一般（3分）', score: 3 },
              { label: '较差（-2分）', score: -2 }
            ]
          }
        ]
      }
    ]
  },
  {
    id: 'ji3',
    name: '经营业绩',
    maxScore: 45,
    subcategories: [
      {
        id: 'ji3-1',
        name: '重点工作与行为指标、济效益指标、项目管理指标、内部运营指标',
        items: [
          {
            id: 'ji3-1-1',
            name: '上年度《年度经营业绩考核结果》',
            maxScore: 10,
            value: null,
            options: [
              { label: 'A（10分）', score: 10 },
              { label: 'B（8分）', score: 8 },
              { label: 'C（6分）', score: 6 },
              { label: 'D（-5分）', score: -5 }
            ]
          }
        ]
      },
      {
        id: 'ji3-2',
        name: '任期业绩考核、任期业绩考核得分',
        items: [
          {
            id: 'ji3-2-1',
            name: '上一次《任期经营业绩考核结果》',
            maxScore: 10,
            value: null,
            options: [
              { label: 'A（10分）', score: 10 },
              { label: 'B（8分）', score: 8 },
              { label: 'C（6分）', score: 6 },
              { label: 'D（-5分）', score: -5 }
            ]
          }
        ]
      }
    ]
  },
  {
    id: 'ji4',
    name: '效益提升',
    maxScore: 22.5,
    subcategories: [
      {
        id: 'ji4-1',
        name: '降本增效',
        items: [
          {
            id: 'ji4-1-1',
            name: '年度“成本节约率”评价结果',
            maxScore: 10,
            value: null,
            options: [
              { label: '正值（10分）', score: 10 },
              { label: '持平（5分）', score: 5 },
              { label: '负值（0分）', score: 0 }
            ]
          }
        ]
      },
      {
        id: 'ji4-2',
        name: '提质增效',
        items: [
          {
            id: 'ji4-2-1',
            name: '年度“人均营收增长率”评价结果',
            maxScore: 10,
            value: null,
            options: [
              { label: '正值（10分）', score: 10 },
              { label: '持平（5分）', score: 5 },
              { label: '负值（0分）', score: 0 }
            ]
          }
        ]
      }
    ]
  }
])
export const categoriesQin = ([
  {
    id: 'qin1',
    name: '勤勉敬业',
    maxScore: 20,
    subcategories: [
      {
        id: 'qin1-1',
        name: '总体评价',
        items: [
          {
            id: 'qin1-1-1',
            name: '上年度《集团中层管理人员年度考核测评》——总体评价结果',
            maxScore: 12,
            value: null,
            options: [
              { label: '优秀（12分）', score: 12 },
              { label: '称职（10分）', score: 10 },
              { label: '基本称职（8分）', score: 8 },
              { label: '不称职（-5分）', score: -5 }
            ]
          }
        ]
      },
      {
        id: 'qin1-2',
        name: '“勤”评价',
        items: [
          {
            id: 'qin1-2-1',
            name: '上年度《集团中层管理人员年度考核测评》——“勤”评价结果',
            maxScore: 8,
            value: null,
            options: [
              { label: '优秀（8分）', score: 8 },
              { label: '称职（6分）', score: 6 },
              { label: '基本称职（4分）', score: 4 },
              { label: '不称职（-2分）', score: -2 }
            ]
          }
        ]
      }
    ]
  },
  {
    id: 'qin2',
    name: '作风建设',
    maxScore: 15,
    subcategories: [
      {
        id: 'qin2-1',
        name: '班子总体评价',
        items: [
          {
            id: 'qin-2-1',
            name: '上年度《二级企业领导班子年度考核》——总体评价结果',
            maxScore: 10,
            value: null,
            options: [
              { label: '优秀（10分）', score: 10 },
              { label: '良好（8分）', score: 8 },
              { label: '一般（6分）', score: 6 },
              { label: '较差（-5分）', score: -5 }
            ]
          }
        ]
      },
      {
        id: 'qin2-2',
        name: '班子“作风建设”评价',
        items: [
          {
            id: 'qin-2-2',
            name: '上年度《二级企业领导班子年度考核》——“作风建设”评价结果',
            maxScore: 5,
            value: null,
            options: [
              { label: '优秀（5分）', score: 5 },
              { label: '良好（4分）', score: 4 },
              { label: '一般（3分）', score: 3 },
              { label: '较差（-2分）', score: -2 }
            ]
          }
        ]
      }
    ]
  },
  {
    id: 'qin3',
    name: '锐意改革',
    maxScore: 15,
    subcategories: [
      {
        id: 'qin2-1',
        name: '三项制度改革',
        items: [
          {
            id: 'qin-3-1',
            name: '劳动制度——员工市场化综合流动率评价结果',
            maxScore: 12,
            value: null,
            options: [
              { label: '增加（12分）', score: 12 },
              { label: '持平（9分）', score: 9 },
              { label: '减少（3分）', score: 3 }
            ]
          },
          {
            id: 'qin-3-2',
            name: '人事制度——竞聘上岗比例评价结果',
            maxScore: 12,
            value: null,
            options: [
              { label: '50%及以上（12分）', score: 12 },
              { label: '30%及以上（9分）', score: 9 },
              { label: '10%（6分）', score: 6 }
            ]
          },
          {
            id: 'qin-3-3',
            name: '分配制度——绩效工资浮动幅度评价结果',
            maxScore: 12,
            value: null,
            options: [
              { label: '50%以上（9分）', score: 9 },
              { label: '25%以上（6分）', score: 6 },
              { label: '10%（3分）', score: 3 }
            ]
          }
        ]
      }
    ]
  },
  {
    id: 'qin3',
    name: '社会效益',
    maxScore: 29,
    subcategories: [
      {
        id: 'qin2-1',
        name: '企业荣誉',
        items: [
          {
            id: 'qin-3-1',
            name: '任职期间企业获得国家级、省级、市级、国资委、集团奖励荣誉',
            maxScore: 29,
            value: null,
            options: [
              { label: '国家级', score: 12 },
              { label: '省级', score: 8 },
              { label: '市级', score: 5 },
              { label: '国资委', score: 3 },
              { label: '集团奖励荣誉', score: 2 }
            ]
          }
        ]
      }
    ]
  }
])
export const categoriesLian = ([
  {
    id: 'lian1',
    name: '清正廉洁',
    maxScore: 29,
    subcategories: [
      {
        id: 'lian1-1',
        name: '总体评价',
        items: [
          {
            id: 'lian1-1-1',
            name: '上年度《集团中层管理人员年度考核测评》——总体评价结果',
            maxScore: 12,
            value: null,
            options: [
              { label: '优秀（12分）', score: 12 },
              { label: '称职（10分）', score: 10 },
              { label: '基本称职（8分）', score: 8 },
              { label: '不称职（-5分）', score: -5 }
            ]
          }
        ]
      },
      {
        id: 'lian1-2',
        name: '“廉”评价',
        items: [
          {
            id: 'lian1-2-1',
            name: '上年度《集团中层管理人员年度考核测评》——“廉”评价结果',
            maxScore: 8,
            value: null,
            options: [
              { label: '优秀（8分）', score: 8 },
              { label: '称职（6分）', score: 6 },
              { label: '基本称职（4分）', score: 4 },
              { label: '不称职（-2分）', score: -2 }
            ]
          }
        ]
      }
    ]
  },
  {
    id: 'lian2',
    name: '党风廉政建设',
    maxScore: 29,
    subcategories: [
      {
        id: 'lian2-1',
        name: '班子总体评价',
        items: [
          {
            id: 'lian2-1-1',
            name: '上年度《二级企业领导班子年度考核》——总体评价结果',
            maxScore: 10,
            value: null,
            options: [
              { label: '优秀（10分）', score: 10 },
              { label: '良好（8分）', score: 8 },
              { label: '一般（6分）', score: 6 },
              { label: '较差（-5分）', score: -5 }
            ]
          }
        ]
      },
      {
        id: 'lian2-2',
        name: '班子“党风廉政建设”评价',
        items: [
          {
            id: 'lian2-2-1',
            name: '上年度《二级企业领导班子年度考核》——“党风廉政建设”评价结果',
            maxScore: 5,
            value: null,
            options: [
              { label: '优秀（5分）', score: 5 },
              { label: '良好（4分）', score: 4 },
              { label: '一般（3分）', score: 3 },
              { label: '较差（-2分）', score: -2 }
            ]
          }
        ]
      }
    ]
  },
  {
    id: 'lian3',
    name: '纪检监察',
    maxScore: 29,
    subcategories: [
      {
        id: 'lian3-1',
        name: '纪检监察表现',
        items: [
          {
            id: 'lian3-1-1',
            name: '监督执纪——《年度经营业绩考核》纪检监察业务考核指标',
            maxScore: 10,
            value: null,
            options: [
              { label: '10分', score: 10 },
              { label: '9分', score: 9 },
              { label: '8分', score: 8 },
              { label: '7分', score: 7 },
              { label: '6分', score: 6 },
              { label: '5分', score: 5 },
              { label: '4分', score: 4 },
              { label: '3分', score: 3 },
              { label: '2分', score: 2 },
              { label: '1分', score: 1 },
              { label: '0分', score: 0 }
            ]
          },
          {
            id: 'lian3-1-2',
            name: '教育预防——参加教育警示活动率',
            maxScore: 10,
            value: null,
            options: [
              { label: '优秀（90%以上，10分）', score: 10 },
              { label: '良好（80%以上，8分）', score: 8 },
              { label: '一般（60%以上，5分）', score: 5 },
              { label: '较差（60%以下，0分）', score: 0 }
            ]
          },
          {
            id: 'lian3-1-3',
            name: '自身建设——个人事项申报完整性',
            maxScore: 13,
            value: null,
            options: [
              { label: '完整（13分）', score: 13 },
              { label: '不完整（0分）', score: 0 }
            ]
          }
        ]
      }
    ]
  },
  {
    id: 'lian4',
    name: '审计整改',
    maxScore: 29,
    subcategories: [
      {
        id: 'lian4-1',
        name: '审计整改表现',
        items: [
          {
            id: 'lian4-1-1',
            name: '政策执行审计表现——审计整改完成情况',
            maxScore: 11,
            value: null,
            options: [
              { label: '完成（11分）', score: 11 },
              { label: '未完成（0分）', score: 0 }
            ]
          },
          {
            id: 'lian4-1-2',
            name: '财务管控审计表现——资产保值增值率',
            maxScore: 11,
            value: null,
            options: [
              { label: '增加（11分）', score: 11 },
              { label: '持平（8分）', score: 8 },
              { label: '减少（6分）', score: 6 }
            ]
          },
          {
            id: 'lian4-1-3',
            name: '廉洁从业审计表现——个人违规事项情况',
            maxScore: 10,
            value: null,
            options: [
              { label: '无违规（10分）', score: 10 },
              { label: '有违规（0分）', score: 0 }
            ]
          }
        ]
      }
    ]
  }
])
export const categoriesJiang = ([
  {
    id: 'jl1',
    name: '党建类',
    maxScore: 25,
    subcategories: [
      {
        id: 'jl1-1',
        name: '党组织奖励',
        items: [
          {
            id: 'jl1-1-1',
            name: '国家级、省级、市级、国资委、集团、优秀共产党员、优秀党务工作者、先进基层党组织、专项荣誉称号',
            maxScore: 25,
            value: null,
            options: [
              { label: '国家级（每项12分）', score: 12 },
              { label: '省级（每项8分）', score: 8 },
              { label: '市级（每项5分）', score: 5 },
              { label: '国资委级（每项3分）', score: 3 },
              { label: '集团级（每项2分）', score: 2 }
            ]
          }
        ]
      }
    ]
  },
  {
    id: 'jl2',
    name: '贡献类',
    maxScore: 25,
    subcategories: [
      {
        id: 'jl2-1',
        name: '荣誉称号',
        items: [
          {
            id: 'jl2-1-1',
            name: '国家级、省级、市级、国资委、集团、劳动模范、先进工作者等荣誉称号',
            maxScore: 25,
            value: null,
            options: [
              { label: '国家级（每项12分）', score: 12 },
              { label: '省级（每项8分）', score: 8 },
              { label: '市级（每项5分）', score: 5 },
              { label: '国资委级（每项3分）', score: 3 },
              { label: '集团级（每项2分）', score: 2 }
            ]
          }
        ]
      }
    ]
  },
  {
    id: 'jl3',
    name: '人才类',
    maxScore: 25,
    subcategories: [
      {
        id: 'jl3-1',
        name: '人才称号',
        items: [
          {
            id: 'jl3-1-1',
            name: '人才称号',
            maxScore: 25,
            value: null,
            options: [
              { label: '国家级津贴（20分）', score: 20 },
              { label: '省级津贴（12分）', score: 12 },
              { label: '市级津贴（8分）', score: 8 },
              { label: '特殊津贴专家（18分）', score: 18 },
              { label: '兴辽英才计划（18分）', score: 18 },
              { label: '兴连英才高层次人才（14分）', score: 14 },
              { label: '重点企业人才（3分）', score: 3 }
            ]
          }
        ]
      }
    ]
  },
  {
    id: 'jl4',
    name: '技术类',
    maxScore: 25,
    subcategories: [
      {
        id: 'jl4-1',
        name: '科技与项目奖励',
        items: [
          {
            id: 'jl4-1-1',
            name: '国家级、省级、市级优秀项目、科技进步等奖项荣誉。',
            maxScore: 25,
            value: null,
            options: [
              { label: '国家级优秀奖（10分）', score: 10 },
              { label: '省级优秀奖（4分）', score: 4 },
              { label: '市级优秀奖（2分）', score: 2 },
              { label: '国家级科技进步奖（12分）', score: 12 },
              { label: '省级科技进步奖（8分）', score: 8 },
              { label: '市级科技进步奖（5分）', score: 5 }
            ]
          }
        ]
      }
    ]
  }
])


export const categoriesDe1 = ([
  {
    id: 'de01',
    name: '上年度《集团中层管理人员年度考核测评》——总体评价结果',
    maxScore: 12,
    value: null,
    options: [
      { label: '优秀（12分）', score: 12 },
      { label: '称职（10分）', score: 10 },
      { label: '基本称职（8分）', score: 8 },
      { label: '不称职（-5分）', score: -5 }
    ]
  },
  {
    id: 'de02',
    name: '上年度《集团中层管理人员年度考核测评》——“德”评价结果',
    maxScore: 8,
    value: null,
    options: [
      { label: '优秀（8分）', score: 8 },
      { label: '称职（6分）', score: 6 },
      { label: '基本称职（4分）', score: 4 },
      { label: '不称职（-2分）', score: -2 }
    ]
  },
  {
    id: 'de03',
    name: '上年度《二级企业领导班子年度考核》——总体评价结果',
    maxScore: 10,
    value: null,
    options: [
      { label: '优秀（10分）', score: 10 },
      { label: '良好（8分）', score: 8 },
      { label: '一般（6分）', score: 6 },
      { label: '较差（-5分）', score: -5 }
    ]
  },
  {
    id: 'de04',
    name: '上年度《二级企业领导班子年度考核》——“政治思想建设”评价结果',
    maxScore: 5,
    value: null,
    options: [
      { label: '优秀（5分）', score: 5 },
      { label: '良好（4分）', score: 4 },
      { label: '一般（3分）', score: 3 },
      { label: '较差（-2分）', score: -2 }
    ]
  },
  {
    id: 'de05',
    name: '上年度《政治表现正向评价》——总体评价结果',
    maxScore: 15,
    value: null,
    options: [
      { label: '好（15分）', score: 15 },
      { label: '较好（13分）', score: 13 },
      { label: '一般（10分）', score: 10 },
      { label: '差（-5分）', score: -5 }
    ]
  },
  {
    id: 'de06',
    name: '上年度《民主评议党员测评》——综合评价结果',
    maxScore: 15,
    value: null,
    options: [
      { label: '优秀（15分）', score: 15 },
      { label: '合格（13分）', score: 13 },
      { label: '基本合格（10分）', score: 10 },
      { label: '不合格（-5分）', score: -5 }
    ]
  },
  {
    id: 'de07',
    name: '《干部任免审批表》——党内职务',
    maxScore: 20,
    value: null,
    options: [
      { label: '党委/总支书记（20分）', score: 20 },
      { label: '党委/总支副书记（18分）', score: 18 },
      { label: '党委/总支委员（16分）', score: 16 },
      { label: '支部书记（12分）', score: 12 },
      { label: '支部委员（10分）', score: 10 }
    ]
  },
  {
    id: 'de08',
    name: '《党组织书记履行干部选拔任用工作职责情况民主评议》——书记总体评价结果',
    maxScore: 2,
    value: null,
    options: [
      { label: '好（2分）', score: 2 },
      { label: '一般（1.5分）', score: 1.5 },
      { label: '不好（-1分）', score: -1 }
    ]
  },
  {
    id: 'de09',
    name: '支部标准化率——对标《党支部建设标准化手册》，达标支部占比',
    maxScore: 1.5,
    value: null,
    options: [
      { label: '达标（1.5分）', score: 1.5 },
      { label: '不达标（0分）', score: 0 }
    ]
  },
  {
    id: 'de10',
    name: '组织生活规范度——“三会一课”完成率',
    maxScore: 1.5,
    value: null,
    options: [
      { label: '达标（1.5分）', score: 1.5 },
      { label: '不达标（0分）', score: 0 }
    ]
  },
  {
    id: 'de11',
    name: '贯彻中央八项规定精神学习教育实施方案要求完成情况',
    maxScore: 10,
    value: null,
    options: [
      { label: '达标（10分）', score: 10 },
      { label: '不达标（0分）', score: 0 }
    ]
  }
])
export const categoriesNeng1 = ([

  {
    id: 'neng01',
    name: '上年度《集团中层管理人员年度考核测评》——总体评价结果',
    maxScore: 12,
    value: null,
    options: [
      { label: '优秀（12分）', score: 12 },
      { label: '称职（10分）', score: 10 },
      { label: '基本称职（8分）', score: 8 },
      { label: '不称职（-5分）', score: -5 }
    ]
  },
  {
    id: 'neng02',
    name: '上年度《集团中层管理人员年度考核测评》——“能”评价结果',
    maxScore: 8,
    value: null,
    options: [
      { label: '优秀（8分）', score: 8 },
      { label: '称职（6分）', score: 6 },
      { label: '基本称职（4分）', score: 4 },
      { label: '不称职（-2分）', score: -2 }
    ]
  },
  {
    id: 'neng03',
    name: '上年度《二级企业领导班子年度考核》——总体评价结果',
    maxScore: 10,
    value: null,
    options: [
      { label: '优秀（10分）', score: 10 },
      { label: '良好（8分）', score: 8 },
      { label: '一般（6分）', score: 6 },
      { label: '较差（-5分）', score: -5 }
    ]
  },
  {
    id: 'neng04',
    name: '上年度《二级企业领导班子年度考核》——“领导能力”评价结果',
    maxScore: 5,
    value: null,
    options: [
      { label: '优秀（5分）', score: 5 },
      { label: '良好（4分）', score: 4 },
      { label: '一般（3分）', score: 3 },
      { label: '较差（-2分）', score: -2 }
    ]
  },
  {
    id: 'neng05',
    name: '上年度《干部选拔任用工作民主评议》——单位总体评价',
    maxScore: 7,
    value: null,
    options: [
      { label: '好（7分）', score: 7 },
      { label: '一般（5分）', score: 5 },
      { label: '不好（-3分）', score: -3 }
    ]
  },
  {
    id: 'neng06',
    name: '上年度《干部选拔任用工作民主评议》——全方位管理和经常性监督评价',
    maxScore: 7,
    value: null,
    options: [
      { label: '好（7分）', score: 7 },
      { label: '一般（5分）', score: 5 },
      { label: '不好（-3分）', score: -3 }
    ]
  },
  {
    id: 'neng07',
    name: '任职以来企业取得高新技术企业、雏鹰企业、瞪羚企业、专精特新企业、市企业技术中心等科技称号',
    maxScore: 16,
    value: null,
    options: [
      { label: '一项（4分）', score: 4 },
      { label: '两项（8分）', score: 8 },
      { label: '三项（12分）', score: 12 },
      { label: '四项（16分）', score: 16 }
    ]
  },
  {
    id: 'neng08',
    name: '《干部任免审批表》——行政职务',
    maxScore: 20,
    value: null,
    options: [
      { label: '集团层面（20分）', score: 20 },
      { label: '正职（18分）', score: 18 },
      { label: '副职（16分）', score: 16 }
    ]
  },
  {
    id: 'neng09',
    name: '学历',
    maxScore: 3.5,
    value: null,
    options: [
      { label: '专科（2分）', score: 2 },
      { label: '本科（3分）', score: 3 },
      { label: '研究生（3.5分）', score: 3.5 }
    ]
  },
  {
    id: 'neng10',
    name: '学位',
    maxScore: 3.5,
    value: null,
    options: [
      { label: '学士学位（2.5分）', score: 2.5 },
      { label: '硕士学位（3分）', score: 3 },
      { label: '博士学位（3.5分）', score: 3.5 }
    ]
  },
  {
    id: 'neng11',
    name: '专业技术职务（职称）',
    maxScore: 4,
    value: null,
    options: [
      { label: '初级（2.5分）', score: 2.5 },
      { label: '中级（3分）', score: 3 },
      { label: '高级（3.5分）', score: 3.5 },
      { label: '正高级（4分）', score: 4 }
    ]
  },
  {
    id: 'neng12',
    name: '执业资格(国家执业资格认定证书)',
    maxScore: 4,
    value: null,
    options: [
      { label: '取得（4分）', score: 4 },
      { label: '未取得（0分）', score: 0 }
    ]
  }
])
export const categoriesJi1 = ([

  {
    id: 'ji01',
    name: '上年度《集团中层管理人员年度考核测评》——总体评价结果',
    maxScore: 12,
    value: null,
    options: [
      { label: '优秀（12分）', score: 12 },
      { label: '称职（10分）', score: 10 },
      { label: '基本称职（8分）', score: 8 },
      { label: '不称职（-5分）', score: -5 }
    ]
  },
  {
    id: 'ji02',
    name: '上年度《集团中层管理人员年度考核测评》——“绩”评价结果',
    maxScore: 8,
    value: null,
    options: [
      { label: '优秀（8分）', score: 8 },
      { label: '称职（6分）', score: 6 },
      { label: '基本称职（4分）', score: 4 },
      { label: '不称职（-2分）', score: -2 }
    ]
  },
  {
    id: 'ji03',
    name: '上年度《二级企业领导班子年度考核》——总体评价结果',
    maxScore: 10,
    value: null,
    options: [
      { label: '优秀（10分）', score: 10 },
      { label: '良好（8分）', score: 8 },
      { label: '一般（6分）', score: 6 },
      { label: '较差（-5分）', score: -5 }
    ]
  },
  {
    id: 'ji04',
    name: '上年度《二级企业领导班子年度考核》——“工作实绩”评价结果',
    maxScore: 5,
    value: null,
    options: [
      { label: '优秀（5分）', score: 5 },
      { label: '良好（4分）', score: 4 },
      { label: '一般（3分）', score: 3 },
      { label: '较差（-2分）', score: -2 }
    ]
  },
  {
    id: 'ji05',
    name: '上年度《年度经营业绩考核结果》',
    maxScore: 22.25,
    value: null,
    options: [
      { label: 'A（22.5分）', score: 22.5 },
      { label: 'B（20分）', score: 20 },
      { label: 'C（15分）', score: 15 },
      { label: 'D（7.5分）', score: 7.5 }
    ]
  },
  {
    id: 'ji06',
    name: '上一次《任期经营业绩考核结果》',
    maxScore: 22.25,
    value: null,
    options: [
      { label: 'A（22.5分）', score: 22.5 },
      { label: 'B（20分）', score: 20 },
      { label: 'C（15分）', score: 15 },
      { label: 'D（7.5分）', score: 7.5 }
    ]
  },
  {
    id: 'ji07',
    name: '年度“成本节约率”评价结果',
    maxScore: 10,
    value: null,
    options: [
      { label: '正值（10分）', score: 10 },
      { label: '持平（5分）', score: 5 },
      { label: '负值（0分）', score: 0 }
    ]
  },
  {
    id: 'ji08',
    name: '年度“人均营收增长率”评价结果',
    maxScore: 10,
    value: null,
    options: [
      { label: '正值（10分）', score: 10 },
      { label: '持平（5分）', score: 5 },
      { label: '负值（0分）', score: 0 }
    ]
  }
])
export const categoriesQin1 = ([

  {
    id: 'qin01',
    name: '上年度《集团中层管理人员年度考核测评》——总体评价结果',
    maxScore: 12,
    value: null,
    options: [
      { label: '优秀（12分）', score: 12 },
      { label: '称职（10分）', score: 10 },
      { label: '基本称职（8分）', score: 8 },
      { label: '不称职（-5分）', score: -5 }
    ]
  },
  {
    id: 'qin02',
    name: '上年度《集团中层管理人员年度考核测评》——“勤”评价结果',
    maxScore: 8,
    value: null,
    options: [
      { label: '优秀（8分）', score: 8 },
      { label: '称职（6分）', score: 6 },
      { label: '基本称职（4分）', score: 4 },
      { label: '不称职（-2分）', score: -2 }
    ]
  },
  {
    id: 'qin03',
    name: '上年度《二级企业领导班子年度考核》——总体评价结果',
    maxScore: 10,
    value: null,
    options: [
      { label: '优秀（10分）', score: 10 },
      { label: '良好（8分）', score: 8 },
      { label: '一般（6分）', score: 6 },
      { label: '较差（-5分）', score: -5 }
    ]
  },
  {
    id: 'qin04',
    name: '上年度《二级企业领导班子年度考核》——“作风建设”评价结果',
    maxScore: 5,
    value: null,
    options: [
      { label: '优秀（5分）', score: 5 },
      { label: '良好（4分）', score: 4 },
      { label: '一般（3分）', score: 3 },
      { label: '较差（-2分）', score: -2 }
    ]
  },
  {
    id: 'qin05',
    name: '劳动制度——员工市场化综合流动率评价结果',
    maxScore: 12,
    value: null,
    options: [
      { label: '增加（12分）', score: 12 },
      { label: '持平（9分）', score: 9 },
      { label: '减少（3分）', score: 3 }
    ]
  },
  {
    id: 'qin06',
    name: '人事制度——竞聘上岗比例评价结果',
    maxScore: 12,
    value: null,
    options: [
      { label: '50%及以上（12分）', score: 12 },
      { label: '30%及以上（9分）', score: 9 },
      { label: '10%（6分）', score: 6 }
    ]
  },
  {
    id: 'qin07',
    name: '分配制度——绩效工资浮动幅度评价结果',
    maxScore: 12,
    value: null,
    options: [
      { label: '50%以上（9分）', score: 9 },
      { label: '25%以上（6分）', score: 6 },
      { label: '10%（3分）', score: 3 }
    ]
  },
  {
    id: 'qin08',
    name: '任职期间企业获得国家级、省级、市级、国资委、集团奖励荣誉',
    maxScore: 29,
    value: null,
    options: [
      { label: '国家级', score: 12 },
      { label: '省级', score: 8 },
      { label: '市级', score: 5 },
      { label: '国资委', score: 3 },
      { label: '集团奖励荣誉', score: 2 }
    ]
  }
])
export const categoriesLian1 = ([
  {
    id: 'lian01',
    name: '上年度《集团中层管理人员年度考核测评》——总体评价结果',
    maxScore: 12,
    value: null,
    options: [
      { label: '优秀（12分）', score: 12 },
      { label: '称职（10分）', score: 10 },
      { label: '基本称职（8分）', score: 8 },
      { label: '不称职（-5分）', score: -5 }
    ]
  },
  {
    id: 'lian02',
    name: '上年度《集团中层管理人员年度考核测评》——“廉”评价结果',
    maxScore: 8,
    value: null,
    options: [
      { label: '优秀（8分）', score: 8 },
      { label: '称职（6分）', score: 6 },
      { label: '基本称职（4分）', score: 4 },
      { label: '不称职（-2分）', score: -2 }
    ]
  },
  {
    id: 'lian03',
    name: '上年度《二级企业领导班子年度考核》——总体评价结果',
    maxScore: 10,
    value: null,
    options: [
      { label: '优秀（10分）', score: 10 },
      { label: '良好（8分）', score: 8 },
      { label: '一般（6分）', score: 6 },
      { label: '较差（-5分）', score: -5 }
    ]
  },
  {
    id: 'lian04',
    name: '上年度《二级企业领导班子年度考核》——“党风廉政建设”评价结果',
    maxScore: 5,
    value: null,
    options: [
      { label: '优秀（5分）', score: 5 },
      { label: '良好（4分）', score: 4 },
      { label: '一般（3分）', score: 3 },
      { label: '较差（-2分）', score: -2 }
    ]
  },
  {
    id: 'lian05',
    name: '监督执纪——《年度经营业绩考核》纪检监察业务考核指标',
    maxScore: 10,
    value: null,
    options: [
      { label: '10分', score: 10 },
      { label: '9分', score: 9 },
      { label: '8分', score: 8 },
      { label: '7分', score: 7 },
      { label: '6分', score: 6 },
      { label: '5分', score: 5 },
      { label: '4分', score: 4 },
      { label: '3分', score: 3 },
      { label: '2分', score: 2 },
      { label: '1分', score: 1 },
      { label: '0分', score: 0 }
    ]
  },
  {
    id: 'lian06',
    name: '教育预防——参加教育警示活动率',
    maxScore: 10,
    value: null,
    options: [
      { label: '优秀（90%以上，10分）', score: 10 },
      { label: '良好（80%以上，8分）', score: 8 },
      { label: '一般（60%以上，5分）', score: 5 },
      { label: '较差（60%以下，0分）', score: 0 }
    ]
  },
  {
    id: 'lian07',
    name: '自身建设——个人事项申报完整性',
    maxScore: 13,
    value: null,
    options: [
      { label: '完整（13分）', score: 13 },
      { label: '不完整（0分）', score: 0 }
    ]
  },
  {
    id: 'lian08',
    name: '政策执行审计表现——审计整改完成情况',
    maxScore: 11,
    value: null,
    options: [
      { label: '完成（11分）', score: 11 },
      { label: '未完成（0分）', score: 0 }
    ]
  },
  {
    id: 'lian09',
    name: '财务管控审计表现——资产保值增值率',
    maxScore: 11,
    value: null,
    options: [
      { label: '增加（11分）', score: 11 },
      { label: '持平（8分）', score: 8 },
      { label: '减少（6分）', score: 6 }
    ]
  },
  {
    id: 'lian10',
    name: '廉洁从业审计表现——个人违规事项情况',
    maxScore: 10,
    value: null,
    options: [
      { label: '无违规（10分）', score: 10 },
      { label: '有违规（0分）', score: 0 }
    ]
  }
])
export const categoriesJiang1 = ([

  {
    id: 'jl01',
    name: '国家级、省级、市级、国资委、集团、优秀共产党员、优秀党务工作者、先进基层党组织、专项荣誉称号',
    maxScore: 25,
    value: null,
    options: [
      { label: '国家级（每项12分）', score: 12 },
      { label: '省级（每项8分）', score: 8 },
      { label: '市级（每项5分）', score: 5 },
      { label: '国资委级（每项3分）', score: 3 },
      { label: '集团级（每项2分）', score: 2 }
    ]
  },
  {
    id: 'jl02',
    name: '国家级、省级、市级、国资委、集团、劳动模范、先进工作者等荣誉称号',
    maxScore: 25,
    value: null,
    options: [
      { label: '国家级（每项12分）', score: 12 },
      { label: '省级（每项8分）', score: 8 },
      { label: '市级（每项5分）', score: 5 },
      { label: '国资委级（每项3分）', score: 3 },
      { label: '集团级（每项2分）', score: 2 }
    ]
  },
  {
    id: 'jl03',
    name: '人才称号',
    maxScore: 25,
    value: null,
    options: [
      { label: '国家级津贴（20分）', score: 20 },
      { label: '省级津贴（12分）', score: 12 },
      { label: '市级津贴（8分）', score: 8 },
      { label: '区级津贴（5分）', score: 5 },
      { label: '高层次人才，尖端人才（18分）', score: 18 },
      { label: '领军人才（14分）', score: 14 },
      { label: '高端人才（10分）', score: 10 },
      { label: '青年才俊（6分）', score: 6 },
      { label: '重点企业人才（3分）', score: 3 }
    ]
  },
  {
    id: 'jl04',
    name: '国家级、省级、市级优秀项目、科技进步等奖项荣誉。',
    maxScore: 25,
    value: null,
    options: [
      { label: '国家级优秀奖（10分）', score: 10 },
      { label: '省级优秀奖（4分）', score: 4 },
      { label: '市级优秀奖（2分）', score: 2 },
      { label: '国家级科技进步奖（12分）', score: 12 },
      { label: '省级科技进步奖（8分）', score: 8 },
      { label: '市级科技进步奖（5分）', score: 5 }
    ]
  }
])
