import { defineConfig, loadEnv } from 'vite'
import path from 'path'
// import { fileURLToPath, URL } from 'node:url'
import createVitePlugins from './vite/plugins'

// https://vitejs.dev/config/
export default defineConfig(({ mode, command }) => {
  const env = loadEnv(mode, process.cwd())
  const { VITE_APP_ENV, VITE_APP_BASE_URL } = env
  return {
    // 部署生产环境和开发环境下的URL。
    // 默认情况下，vite 会假设你的应用是被部署在一个域名的根路径上
    // 例如 https://www.ruoyi.vip/。如果应用被部署在一个子路径上，你就需要用这个选项指定这个子路径。例如，如果你的应用被部署在 https://www.ruoyi.vip/admin/，则设置 baseUrl 为 /admin/。
    base: VITE_APP_BASE_URL,
    resolve: {
      dedupe: [
        'vue'
      ],
      // https://cn.vitejs.dev/config/#resolve-alias
      alias: {
        // 设置路径
        '~': path.resolve(__dirname, './'),
        // '~': fileURLToPath(new URL('./', import.meta.url)),
        // 设置别名
        '@': path.resolve(__dirname, './src')
        // '@': fileURLToPath(new URL('./src', import.meta.url))
      },
      // https://cn.vitejs.dev/config/#resolve-extensions
      extensions: ['.mjs', '.js', '.ts', '.jsx', '.tsx', '.json', '.vue']
    },
    esbuild: {
      drop: mode === 'production' ? ['console', 'debugger'] : []
    },
    build: {
      target: 'esnext'
    },
    // vite 相关配置
    server: {
      port: 8882,
      host: true,
      open: false,
      proxy: {
        // https://cn.vitejs.dev/config/#server-proxy
        '/dev-api': {
          target: 'http://localhost:8080',
          // target: 'http://demo.docmis.cn:22880/prod-api',
          // target: 'http://10.1.1.188/prod-api',
          // target: 'http://10.1.1.208/prod-api',
          changeOrigin: true,
          rewrite: (p) => p.replace(/^\/dev-api/, '')
        }
      }
    },
    // fix:error:stdin>:7356:1: warning: "@charset" must be the first rule in the file
    css: {
      preprocessorOptions: {
        scss: {
          additionalData: '@use "@/assets/styles/variables.scss" as *;'
          // additionalData: '@import "./src/assets/styles/variables.module.scss";',
          // javascriptEnabled: true
        }
      },
      postcss: {
        plugins: [
          {
            postcssPlugin: 'internal:charset-removal',
            AtRule: {
              charset: (atRule) => {
                if (atRule.name === 'charset') {
                  atRule.remove()
                }
              }
            }
          }
        ]
      }
    },
    plugins: [
      createVitePlugins(env, command === 'build')
      // vue(),
      // // 自动引入
      // AutoImport({
      //   resolvers: [ElementPlusResolver({
      //     // 自动引入修改主题色添加这一行，使用预处理样式，不添加将会导致使用ElMessage，ElNotification等组件时默认的主题色会覆盖自定义的主题色
      //     importStyle: 'sass'
      //   })]
      // }),
      // Components({
      //   resolvers: [ElementPlusResolver({
      //     // 自动引入修改主题色添加这一行，使用预处理样式
      //     importStyle: 'sass'
      //   })]
      // })
    ]
  }
})
