import vue from '@vitejs/plugin-vue'
// import createUnoCss from './unocss'
// import createAutoImport from './auto-import'
// import createComponents from './components'
// import createIcons from './icons'
import createSvgIconsPlugin from './svg-icon'
import createCompression from './compression'
import createLegacy from './legacy'
// import createSetupExtend from './setup-extend'
import vitePluginZipDist from 'vite-plugin-dist-zip'
import { lazyImport, VxeResolver } from 'vite-plugin-lazy-import'
import path from 'path'

export default (viteEnv: any, isBuild = false): [] => {
  const vitePlugins: any = []
  vitePlugins.push(vue())
  // vitePlugins.push(createUnoCss())
  // vitePlugins.push(createAutoImport(path))
  // vitePlugins.push(createComponents(path))
  vitePlugins.push(createCompression(viteEnv))
  // vitePlugins.push(createIcons())
  vitePlugins.push(createSvgIconsPlugin(path, isBuild))
  // vitePlugins.push(createSetupExtend())
  vitePlugins.push(vitePluginZipDist({ zipName: 'dist' }))
  isBuild && vitePlugins.push(createLegacy(isBuild))
  vitePlugins.push(lazyImport({
    resolvers: [
      VxeResolver({
        libraryName: 'vxe-table'
      }),
      VxeResolver({
        libraryName: 'vxe-pc-ui'
      })
    ]
  }))
  return vitePlugins
}
