import database.InsertData;
import execl.ExcelHandlerFactory;
import text.TextHandlerFactory;
import lombok.extern.slf4j.Slf4j;
import util.ConfigUtil;
import watcher.DirWatcher;

import java.io.File;
import java.nio.file.Path;
import java.util.function.Predicate;

@Slf4j
public class Main {

    public static void main(String[] args) {
        // 监听 text log文件
        Path dirText = Path.of(ConfigUtil.getWatchDir());
        // 设置要匹配的文件规则
        Predicate<File> textFilter = file -> {
            String name = file.getName();
            if (!(name.contains("PASS") && name.endsWith(".txt")))
                return false;
            String fileName = new InsertData().getFileName(name);
            if (name.equals(fileName)) {
                log.info("文件重复，跳过: {}", name);
                return false;
            }
            return true;
        };
        new DirWatcher(dirText, textFilter, new TextHandlerFactory()).startWatch();


        // 监听 excel log文件
        Path dirExcel = Path.of("C:\\Users\\zhugso\\Projects\\chenyang\\testdata\\exc");
        Predicate<File> excelFilter = file -> {
            String name = file.getName();
            return !name.contains("$");
        };
        new DirWatcher(dirExcel, excelFilter, new ExcelHandlerFactory()).startWatch();


        // 阻塞主线程
        log.info("程序已启动");
        try {
            Thread.currentThread().join();
        } catch (InterruptedException e) {
            log.error(e.getMessage(), e);
        }
    }
}
