package handler;

import java.io.File;

public abstract class AbstractFileHandler implements FileHandler {
    protected final File file;

    public AbstractFileHandler(File file) {
        this.file = file;
    }

    @Override
    public File getFile() {
        return file;
    }

    // 每个子类都要实现的具体处理逻辑
    protected abstract void processFile(File file);

    @Override
    public void run() {
        processFile(file);
    }
}