package text;

import database.InsertData;
import domain.ResultData;
import handler.AbstractFileHandler;
import lombok.extern.slf4j.Slf4j;
import util.ZipUtil;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Slf4j
public class TextHandler extends AbstractFileHandler {

    public TextHandler(File file) {
        super(file);
    }

    @Override
    protected void processFile(File file) {
        log.info("文件处理:{}", file.getName());
        String begin = "=+ SUMMARY begin =+";
        String end = "=+ SUMMARY end {2}=+";
        Pattern patternBegin = Pattern.compile(begin);
        Pattern patternEnd = Pattern.compile(end);
        boolean beginFlag = false;
        List<String> patternText = new ArrayList<>();

        try (BufferedReader reader = new BufferedReader(new FileReader(file))) {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty())
                    continue;
                if (patternBegin.matcher(line).find() && !beginFlag) {
                    beginFlag = true;
                    continue;
                }
                if (patternEnd.matcher(line).find() && beginFlag) {
                    break;
                }
                if (beginFlag) {
                    patternText.add(line);
                }
            }
        } catch (IOException e) {
            log.error(e.getMessage());
        }

        // 目标数据匹配
        ResultData data = stringParser(patternText);

        data.setFileName(file.getName());
        String[] ss = file.getName().split("_");
        data.setSn(ss[1]);

        DateFormat format = new SimpleDateFormat("yyyyMMdd-HHmmss");
        Date parse;
        try {
            parse = format.parse(ss[5]);
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }
        data.setTime(parse);

        data.setType("Wifi");

        // 压缩日志文件
        String zipName = ZipUtil.zipFile(file);
        log.info("文件是否删除: {}, {}", file.delete(), file.getName());

        data.setZipFileUrl(zipName);
        data.setFileUrl(file.getParent() + zipName);

        new InsertData().insert(data);
    }

    private ResultData stringParser(List<String> patternText) {
        String regex = "\\[PASS] (?<itemName>.+?) (?<unit>\\w+), value = \"(?<value>[-\\d.]+)\" (?<range>\\([^)]*\\))";
        Pattern pattern = Pattern.compile(regex);
        ResultData data = new ResultData();
        List<ResultData.Item> items = new ArrayList<>();
        for (int i = 10; i < patternText.size(); i += 3) {
            String s1 = patternText.get(i - 2);
            String groupName = s1.substring(4);

            for (int j = i - 1; j < i + 1; j++) {
                String sLine = patternText.get(j);
                Matcher matcher = pattern.matcher(sLine);
                if (matcher.find()) {
                    ResultData.Item item = new ResultData.Item();
                    item.setGroupName(groupName);
                    item.setItemName(matcher.group("itemName"));
                    item.setUnit(matcher.group("unit"));
                    item.setValue(Double.valueOf(matcher.group("value")));
                    item.setRange(matcher.group("range"));
                    items.add(item);
                }
            }
        }
        data.setItem(items);

        return data;
    }

}
