package util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ConfigUtil {
    private static final Properties props = new Properties();
    private static final String propFilePath = "/config.properties";

    static {
        try (InputStream is = ConfigUtil.class.getResourceAsStream(propFilePath)) {
            props.load(is);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ConfigUtil() {
    }

    public static String getWatchDir() {
        return props.getProperty("watch_dir");
    }
    public static String getDBJdbcUrl() {
        return props.getProperty("jdbc_url");
    }
    public static String getDBUsername() {
        return props.getProperty("username");
    }
    public static String getDBPassword() {
        return props.getProperty("password");
    }


}
