package util;

import lombok.extern.slf4j.Slf4j;

import java.io.*;
import java.util.zip.Deflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

@Slf4j
public class ZipUtil {
    private ZipUtil() {
    }

    //String content =  readSingleTextFileFromZip(zipFile, "UTF-8")

    public static String readSingleTextFileFromZip(File zipFile, String charset) {
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile))) {
            ZipEntry entry = zis.getNextEntry();
            if (entry != null && !entry.isDirectory()) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(zis, charset))) {
                    StringBuilder sb = new StringBuilder();
                    String line;
                    while ((line = reader.readLine()) != null) {
                        sb.append(line).append("\n");
                    }
                    return sb.toString();
                }
            }
        } catch (IOException e) {
            throw new RuntimeException("读取 zip 文件失败", e);
        }
        return null;
    }

    public static byte[] readSingleFileFromZip(File zipFile) {
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile))) {
            ZipEntry entry = zis.getNextEntry();
            if (entry != null && !entry.isDirectory()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                int len;
                while ((len = zis.read(buffer)) > 0) {
                    baos.write(buffer, 0, len);
                }
                return baos.toByteArray();
            }
        } catch (IOException e) {
            throw new RuntimeException("读取 zip 文件失败", e);
        }
        return null;
    }

    public static String zipFile(File file) {
        String zipFile = file.getParent() + File.separator
                + getBaseName(file.getName()) + ".zip";
        try (FileOutputStream fos = new FileOutputStream(zipFile);
             ZipOutputStream zos = new ZipOutputStream(fos)) {

            try (FileInputStream fis = new FileInputStream(file)) {
                // 创建 ZipEntry，名字就是压缩包里的文件名
                ZipEntry zipEntry = new ZipEntry(file.getName());
                zos.setLevel(Deflater.BEST_COMPRESSION);
                zos.putNextEntry(zipEntry);

                byte[] buffer = new byte[1024];
                int length;
                while ((length = fis.read(buffer)) >= 0) {
                    zos.write(buffer, 0, length);
                }
            }
            log.info("压缩完成:{}", zipFile);
        } catch (IOException e) {
            log.error(e.getMessage());
        }
        return zipFile;
    }

    private static String getBaseName(String fileName) {
        int dotIndex = fileName.lastIndexOf('.');
        return (dotIndex == -1) ? fileName : fileName.substring(0, dotIndex);
    }


}
