import database.InsertData;
import text.TextFileHandlerFactory;
import lombok.extern.slf4j.Slf4j;
import util.ConfigUtil;
import watcher.DirWatcher;

import java.io.File;
import java.nio.file.Path;
import java.util.function.Predicate;

@Slf4j
public class Main {

    public static void main(String[] args) {
        Path dirText = Path.of(ConfigUtil.getWatchDir());
        // 设置要匹配的文件规则
        Predicate<File> textFilter = file -> {
            String name = file.getName();
            if (!(name.contains("PASS") && name.endsWith(".txt")))
                return false;
            String fileName = new InsertData().getFileName(name);
            if (name.equals(fileName)) {
                log.info("文件重复，跳过: {}", name);
                return false;
            }
            return true;
        };

        new DirWatcher(dirText, textFilter, new TextFileHandlerFactory()).startWatch();


        // 监听 excel log文件
//        File dirExcel = new File("C:\\Users\\zhugso\\Projects\\chenyang\\testdata\\exc");
//        Predicate<File> excelFilter = file -> {
//            String name = file.getName();
//            return !name.contains("$");
//        };
//
//        ExcelFileWatcher excelWatcher = new ExcelFileWatcher(dirExcel, excelFilter);
//        excelWatcher.startWatch();

        // 阻塞主线程
        log.info("程序已启动");
        try {
            Thread.currentThread().join();
        } catch (InterruptedException e) {
            log.error(e.getMessage(), e);
        }
    }
}
