package text;

import database.InsertData;
import domain.ResultData;
import handler.AbstractFileHandler;
import lombok.extern.slf4j.Slf4j;

import java.io.*;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

@Slf4j
public class TextHandler extends AbstractFileHandler {

    public TextHandler(File file) {
        super(file);
    }

    @Override
    protected void processFile(File file) {
        log.info("文件处理:{}", file.getName());
        String begin = "=+ SUMMARY begin =+";
        String end = "=+ SUMMARY end {2}=+";
        Pattern patternBegin = Pattern.compile(begin);
        Pattern patternEnd = Pattern.compile(end);
        boolean beginFlag = false;
        List<String> patternText = new ArrayList<>();

        try (BufferedReader reader = new BufferedReader(new FileReader(file))) {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty())
                    continue;
                if (patternBegin.matcher(line).find() && !beginFlag) {
                    beginFlag = true;
                    continue;
                }
                if (patternEnd.matcher(line).find() && beginFlag) {
                    break;
                }
                if (beginFlag) {
                    patternText.add(line);
                }
            }
        } catch (IOException e) {
            log.error(e.getMessage());
        }

        // 目标数据匹配
        ResultData data = StringParser(patternText);

        data.setFileName(file.getName());
        String[] ss = file.getName().split("_");
        data.setSn(ss[1]);

        DateFormat format = new SimpleDateFormat("yyyyMMdd-HHmmss");
        Date parse;
        try {
            parse = format.parse(ss[5]);
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }
        data.setTime(parse);

        data.setType("Wifi");

        // 压缩日志文件并删除
        String zipName = zipLogFile(file);

        data.setZipFileUrl(zipName);
        data.setFileUrl(file.getParent() + zipName);

        new InsertData().insert(data);
    }

    private ResultData StringParser(List<String> patternText) {
        String regex = "\\[PASS] (?<itemName>.+?) (?<unit>\\w+), value = \"(?<value>[-\\d.]+)\" (?<range>\\([^)]*\\))";
        Pattern pattern = Pattern.compile(regex);
        ResultData data = new ResultData();
        List<ResultData.Item> items = new ArrayList<>();
        for (int i = 10; i < patternText.size(); i += 3) {
            String s1 = patternText.get(i - 2);
            String groupName = s1.substring(4);

            for (int j = i - 1; j < i + 1; j++) {
                String sLine = patternText.get(j);
                Matcher matcher = pattern.matcher(sLine);
                if (matcher.find()) {
                    ResultData.Item item = new ResultData.Item();
                    item.setGroupName(groupName);
                    item.setItemName(matcher.group("itemName"));
                    item.setUnit(matcher.group("unit"));
                    item.setValue(Double.valueOf(matcher.group("value")));
                    item.setRange(matcher.group("range"));
                    items.add(item);
                }
            }
        }
        data.setItem(items);

        return data;
    }


    private String zipLogFile(File file) {
        String zipFile = file.getParent() + File.separator
                + getBaseName(file.getName()) + ".zip";
        try (FileOutputStream fos = new FileOutputStream(zipFile);
             ZipOutputStream zos = new ZipOutputStream(fos)) {

            try (FileInputStream fis = new FileInputStream(file)) {
                // 创建 ZipEntry，名字就是压缩包里的文件名
                ZipEntry zipEntry = new ZipEntry(file.getName());
                zos.putNextEntry(zipEntry);

                byte[] buffer = new byte[1024];
                int length;
                while ((length = fis.read(buffer)) >= 0) {
                    zos.write(buffer, 0, length);
                }
            }
            log.info("压缩完成:{}", zipFile);
            log.info("文件是否删除: {}, {}", file.delete(), file.getName());

        } catch (IOException e) {
            log.error(e.getMessage());
        }
        return zipFile;
    }

    private String getBaseName(String fileName) {
        int dotIndex = fileName.lastIndexOf('.');
        return (dotIndex == -1) ? fileName : fileName.substring(0, dotIndex);
    }


}
