package util;

import java.io.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipUtil {
    private ZipUtil() {
    }

    //String content =  readSingleTextFileFromZip(zipFile, "UTF-8")

    public static String readSingleTextFileFromZip(File zipFile, String charset) {
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile))) {
            ZipEntry entry = zis.getNextEntry();
            if (entry != null && !entry.isDirectory()) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(zis, charset))) {
                    StringBuilder sb = new StringBuilder();
                    String line;
                    while ((line = reader.readLine()) != null) {
                        sb.append(line).append("\n");
                    }
                    return sb.toString();
                }
            }
        } catch (IOException e) {
            throw new RuntimeException("读取 zip 文件失败", e);
        }
        return null;
    }

    public static byte[] readSingleFileFromZip(File zipFile) {
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile))) {
            ZipEntry entry = zis.getNextEntry();
            if (entry != null && !entry.isDirectory()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                int len;
                while ((len = zis.read(buffer)) > 0) {
                    baos.write(buffer, 0, len);
                }
                return baos.toByteArray();
            }
        } catch (IOException e) {
            throw new RuntimeException("读取 zip 文件失败", e);
        }
        return null;
    }



}
