package database;

import domain.ResultData;

import java.sql.*;
import java.util.ArrayList;
import java.util.List;

public class InsertData {
    //sql
    private String insertFileAttr = """
            INSERT INTO file_attr (type, file_name, zip_file_url, file_url, sn, time)
            VALUES (?, ?, ?, ?, ?, ?)
            """;

    private String queryFileAttr = """
            SELECT id FROM file_attr
            WHERE file_name=?
            """;

    private String insertLogDetails = """
            INSERT INTO log_details (file_id, group_name, item_name, item_value, item_spec)
            VALUES (?, ?, ?, ?, ?)
            """;

    private String queryFileNames = """
            SELECT file_name FROM file_attr
            """;

    private String queryFileName = """
            SELECT file_name FROM file_attr WHERE file_name=?
            """;

    public void insert(ResultData rs) {
        try (Connection con = DataSource.getConnection()) {
            try (PreparedStatement ps = con.prepareStatement(insertFileAttr)) {
                ps.setString(1, rs.getType());
                ps.setString(2, rs.getFileName());
                ps.setString(3, rs.getZipFileUrl());
                ps.setString(4, rs.getFileUrl());
                ps.setString(5, rs.getSn());
                ps.setDate(6, new Date(rs.getTime().getTime()));
                ps.execute();
            }
            int id;
            try (PreparedStatement ps = con.prepareStatement(queryFileAttr)) {
                ps.setString(1, rs.getFileName());
                ResultSet resultSet = ps.executeQuery();
                resultSet.next();
                id = resultSet.getInt(1);
            }
            try (PreparedStatement ps = con.prepareStatement(insertLogDetails)) {
                ps.setInt(1, id);
                List<ResultData.Item> items = rs.getItem();
                for (ResultData.Item item : items) {
                    ps.setString(2, item.getGroupName());
                    ps.setString(3, item.getItemName());
                    ps.setDouble(4, item.getValue());
                    ps.setString(5, item.getRange());
                    ps.execute();
                }
            }

        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getFileName(String fileName) {
        try (Connection con = DataSource.getConnection()) {
            try (PreparedStatement ps = con.prepareStatement(queryFileName)) {
                ps.setString(1, fileName);
                ResultSet resultSet = ps.executeQuery();
                if (resultSet.next()) {
                    return resultSet.getString(1);
                }
                return "";
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getFileNames() {
        List<String> list = new ArrayList<>();
        try (Connection con = DataSource.getConnection()) {
            try (PreparedStatement ps = con.prepareStatement(queryFileNames)) {
                ResultSet resultSet = ps.executeQuery();
                while (resultSet.next()) {
                    list.add(resultSet.getString(1));
                }
                return list;
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}
